/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.container;

import cn.crane4j.annotation.ContainerMethod;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.container.MethodContainerFactory;
import cn.crane4j.core.support.container.MethodInvokerContainerCreator;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMethodContainerFactory
implements MethodContainerFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultMethodContainerFactory.class);
    public static final int ORDER = Integer.MAX_VALUE;
    protected final MethodInvokerContainerCreator methodInvokerContainerCreator;
    protected final AnnotationFinder annotationFinder;

    public DefaultMethodContainerFactory(MethodInvokerContainerCreator methodInvokerContainerCreator, AnnotationFinder annotationFinder) {
        this.methodInvokerContainerCreator = methodInvokerContainerCreator;
        this.annotationFinder = annotationFinder;
    }

    @Override
    public int getSort() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean support(Object source, Method method, Collection<ContainerMethod> annotations) {
        return !Objects.equals(method.getReturnType(), Void.TYPE);
    }

    @Override
    public List<Container<Object>> get(Object source, Method method, Collection<ContainerMethod> annotations) {
        return annotations.stream().map(annotation -> this.methodInvokerContainerCreator.createContainer(source, method, annotation.type(), annotation.namespace(), annotation.resultType(), annotation.resultKey())).collect(Collectors.toList());
    }
}

