/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.container.query;

import cn.crane4j.annotation.MappingType;
import cn.crane4j.core.container.Container;
import cn.crane4j.core.container.ContainerProvider;
import cn.crane4j.core.container.MethodInvokerContainer;
import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.container.MethodInvokerContainerCreator;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.StringUtils;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractQueryContainerProvider<T>
implements ContainerProvider {
    private static final Logger log = LoggerFactory.getLogger(AbstractQueryContainerProvider.class);
    protected final Map<String, Repository<T>> registeredRepositories = new ConcurrentHashMap<String, Repository<T>>(32);
    protected final MethodInvokerContainerCreator methodInvokerContainerCreator;

    public final void registerRepository(String name, T target) {
        Objects.requireNonNull(name, "repository name must not null");
        Objects.requireNonNull(target, "repository must not null");
        CollectionUtils.computeIfAbsent(this.registeredRepositories, name, n -> this.createRepository((String)n, target));
    }

    protected abstract Repository<T> createRepository(String var1, T var2);

    @Override
    public <K> @Nullable Container<K> getContainer(String namespace) {
        return this.createQueryContainer(namespace);
    }

    public <K> Container<K> getQueryContainer(String name, @Nullable String keyProperty, @Nullable List<String> properties) {
        String namespace = this.determineNamespace(name, keyProperty, properties);
        return this.getContainer(namespace);
    }

    public abstract String determineNamespace(String var1, @Nullable String var2, @Nullable List<String> var3);

    protected abstract QueryInfo resolveQueryInfo(String var1);

    private Container<?> createQueryContainer(String namespace) {
        QueryInfo queryInfo = this.resolveQueryInfo(namespace);
        Asserts.isNotNull(queryInfo, "cannot resolve query info for namespace [{}]", namespace);
        String name = queryInfo.getRepository();
        String keyProperty = queryInfo.getKeyProperty();
        List<String> properties = queryInfo.getProperties();
        Repository repository = this.registeredRepositories.get(name);
        Asserts.isNotNull(repository, "cannot find repository [{}]", name);
        Set queryColumns = CollectionUtils.defaultIfEmpty(properties, Collections.emptyList()).stream().map(p -> repository.propertyToQueryColumn((String)p, (String)p)).collect(Collectors.toCollection(LinkedHashSet::new));
        keyProperty = StringUtils.emptyToDefault(keyProperty, repository.getKeyProperty());
        String keyColumn = repository.propertyToColumn(keyProperty, keyProperty);
        String keyQueryColumn = repository.propertyToQueryColumn(keyProperty, keyProperty);
        if (!queryColumns.isEmpty()) {
            queryColumns.add(keyQueryColumn);
        }
        return this.doCreateContainer(namespace, keyProperty, repository, queryInfo, queryColumns, keyColumn);
    }

    private MethodInvokerContainer doCreateContainer(String namespace, String keyProperty, Repository<T> repository, QueryInfo queryInfo, Set<String> queryColumns, String keyColumn) {
        MethodInvoker methodInvoker = this.createMethodInvoker(namespace, repository, queryColumns, keyColumn, keyProperty);
        return this.methodInvokerContainerCreator.createContainer(repository.getTarget(), methodInvoker, queryInfo.getMappingType(), namespace, repository.getEntityType(), keyProperty);
    }

    protected abstract @NonNull MethodInvoker createMethodInvoker(String var1, Repository<T> var2, Set<String> var3, String var4, String var5);

    public void destroy() {
        this.registeredRepositories.clear();
    }

    public AbstractQueryContainerProvider(MethodInvokerContainerCreator methodInvokerContainerCreator) {
        this.methodInvokerContainerCreator = methodInvokerContainerCreator;
    }

    public Map<String, Repository<T>> getRegisteredRepositories() {
        return this.registeredRepositories;
    }

    public static interface QueryInfo {
        public String getRepository();

        public @Nullable String getKeyProperty();

        public @Nullable List<String> getProperties();

        public MappingType getMappingType();
    }

    public static interface Repository<T> {
        public T getTarget();

        public String getTableName();

        public Class<?> getEntityType();

        public String getKeyProperty();

        public String propertyToColumn(String var1, String var2);

        public String propertyToQueryColumn(String var1, String var2);
    }
}

