/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.converter;

import java.util.Objects;
import java.util.function.BiFunction;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ConverterManager {
    public <T, R> @Nullable BiFunction<T, R, R> getConverter(Class<T> var1, Class<R> var2);

    default public <T, R> R convert(T target, Class<R> resultType, R defaultResult) {
        if (Objects.isNull(target)) {
            return defaultResult;
        }
        BiFunction<?, R, R> converter = this.getConverter(target.getClass(), resultType);
        return Objects.nonNull(converter) ? converter.apply(target, defaultResult) : defaultResult;
    }

    default public <T, R> R convert(T target, Class<R> resultType) {
        return this.convert(target, resultType, null);
    }
}

