/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.converter;

import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.converter.ConverterManager;
import cn.crane4j.core.util.ArrayUtils;
import java.util.Objects;

public class ParameterConvertibleMethodInvoker
implements MethodInvoker {
    private final MethodInvoker methodInvoker;
    private final ConverterManager converterManager;
    private final Class<?>[] parameterTypes;

    public static MethodInvoker create(MethodInvoker methodInvoker, ConverterManager converterManager, Class<?>[] parameterTypes) {
        Objects.requireNonNull(methodInvoker, "methodInvoker name must not null");
        Objects.requireNonNull(converterManager, "converterManager name must not null");
        return ArrayUtils.length(parameterTypes) == 0 ? methodInvoker : new ParameterConvertibleMethodInvoker(methodInvoker, converterManager, parameterTypes);
    }

    @Override
    public Object invoke(Object target, Object ... args) {
        Object[] actualArgs = this.resolveInvocationArguments(args);
        return this.methodInvoker.invoke(target, actualArgs);
    }

    private Object[] resolveInvocationArguments(Object ... args) {
        int parameterCount = this.parameterTypes.length;
        if (ArrayUtils.isEmpty(args)) {
            return new Object[parameterCount];
        }
        Object[] actualArgs = new Object[parameterCount];
        if (parameterCount >= args.length) {
            for (int i = 0; i < args.length; ++i) {
                actualArgs[i] = this.converterManager.convert(args[i], this.parameterTypes[i]);
            }
        } else {
            for (int i = 0; i < parameterCount; ++i) {
                actualArgs[i] = this.converterManager.convert(args[i], this.parameterTypes[i]);
            }
        }
        return actualArgs;
    }

    private ParameterConvertibleMethodInvoker(MethodInvoker methodInvoker, ConverterManager converterManager, Class<?>[] parameterTypes) {
        this.methodInvoker = methodInvoker;
        this.converterManager = converterManager;
        this.parameterTypes = parameterTypes;
    }
}

