/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.reflect;

import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.converter.ConverterManager;
import cn.crane4j.core.support.reflect.ReflectivePropertyOperator;
import cn.crane4j.core.util.CollectionUtils;
import com.esotericsoftware.reflectasm.FieldAccess;
import com.esotericsoftware.reflectasm.MethodAccess;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AsmReflectivePropertyOperator
extends ReflectivePropertyOperator {
    private final Map<Class<?>, MethodAccess> methodAccessCaches = new ConcurrentHashMap();
    private final Map<Class<?>, FieldAccess> fieldAccessCaches = new ConcurrentHashMap();

    public AsmReflectivePropertyOperator(@Nullable ConverterManager converterManager) {
        super(converterManager);
    }

    @Override
    protected MethodInvoker createInvokerForMethod(Class<?> targetType, String propertyName, Method method) {
        MethodAccess access = CollectionUtils.computeIfAbsent(this.methodAccessCaches, targetType, MethodAccess::get);
        int methodIndex = access.getIndex(method.getName(), (Class[])method.getParameterTypes());
        return new ReflectAsmMethodInvoker(methodIndex, access);
    }

    @Override
    protected MethodInvoker createSetterInvokerForField(Class<?> targetType, String propertyName, Field field) {
        if (Modifier.isPrivate(field.getModifiers())) {
            return super.createSetterInvokerForField(targetType, propertyName, field);
        }
        FieldAccess access = CollectionUtils.computeIfAbsent(this.fieldAccessCaches, targetType, FieldAccess::get);
        try {
            int fieldIndex = access.getIndex(field.getName());
            return new ReflectAsmFieldAdapterSetterInvoker(access, fieldIndex);
        }
        catch (IllegalArgumentException e) {
            return super.createSetterInvokerForField(targetType, propertyName, field);
        }
    }

    @Override
    protected MethodInvoker createGetterInvokerForField(Class<?> targetType, String propertyName, Field field) {
        if (Modifier.isPrivate(field.getModifiers())) {
            return super.createGetterInvokerForField(targetType, propertyName, field);
        }
        FieldAccess access = CollectionUtils.computeIfAbsent(this.fieldAccessCaches, targetType, FieldAccess::get);
        try {
            int fieldIndex = access.getIndex(field.getName());
            return new ReflectAsmFieldAdapterGetterInvoker(access, fieldIndex);
        }
        catch (IllegalArgumentException e) {
            return super.createGetterInvokerForField(targetType, propertyName, field);
        }
    }

    public static class ReflectAsmFieldAdapterSetterInvoker
    extends ReflectAsmFieldInvoker {
        public ReflectAsmFieldAdapterSetterInvoker(FieldAccess fieldAccess, int fieldIndex) {
            super(fieldAccess, fieldIndex);
        }

        @Override
        protected Object invoke(FieldAccess fieldAccess, int fieldIndex, @Nullable Object target, Object ... args) {
            fieldAccess.set(target, fieldIndex, args[0]);
            return null;
        }
    }

    public static class ReflectAsmFieldAdapterGetterInvoker
    extends ReflectAsmFieldInvoker {
        public ReflectAsmFieldAdapterGetterInvoker(FieldAccess fieldAccess, int fieldIndex) {
            super(fieldAccess, fieldIndex);
        }

        @Override
        protected Object invoke(FieldAccess fieldAccess, int fieldIndex, @Nullable Object target, Object ... args) {
            return fieldAccess.get(target, fieldIndex);
        }
    }

    public static abstract class ReflectAsmFieldInvoker
    implements MethodInvoker {
        private final FieldAccess fieldAccess;
        private final int fieldIndex;

        protected ReflectAsmFieldInvoker(FieldAccess fieldAccess, int fieldIndex) {
            this.fieldAccess = fieldAccess;
            this.fieldIndex = fieldIndex;
        }

        @Override
        public Object invoke(@Nullable Object target, Object ... args) {
            return this.invoke(this.fieldAccess, this.fieldIndex, target, args);
        }

        protected abstract Object invoke(FieldAccess var1, int var2, @Nullable Object var3, Object ... var4);
    }

    public static class ReflectAsmMethodInvoker
    implements MethodInvoker {
        private final int methodIndex;
        private final MethodAccess methodAccess;

        @Override
        public Object invoke(@Nullable Object target, Object ... args) {
            return this.methodAccess.invoke(target, this.methodIndex, args);
        }

        public ReflectAsmMethodInvoker(int methodIndex, MethodAccess methodAccess) {
            this.methodIndex = methodIndex;
            this.methodAccess = methodAccess;
        }
    }
}

