/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.support.reflect;

import cn.crane4j.core.support.MethodInvoker;
import cn.crane4j.core.support.converter.ConverterManager;
import cn.crane4j.core.support.converter.ParameterConvertibleMethodInvoker;
import cn.crane4j.core.support.reflect.PropertyOperator;
import cn.crane4j.core.support.reflect.ReflectiveFieldAdapterMethodInvoker;
import cn.crane4j.core.support.reflect.ReflectiveMethodInvoker;
import cn.crane4j.core.util.Asserts;
import cn.crane4j.core.util.ReflectUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ReflectivePropertyOperator
implements PropertyOperator {
    protected @Nullable ConverterManager converterManager;
    private boolean throwIfNoAnyMatched = false;

    public ReflectivePropertyOperator(@Nullable ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public ReflectivePropertyOperator() {
        this(null);
    }

    @Override
    public @Nullable MethodInvoker findGetter(Class<?> targetType, String propertyName) {
        Method method = ReflectivePropertyOperator.findGetterMethod(targetType, propertyName);
        MethodInvoker methodInvoker = this.resolveInvokerForMethod(targetType, propertyName, method);
        if (methodInvoker != null) {
            return methodInvoker;
        }
        Field field = ReflectUtils.getField(targetType, propertyName);
        MethodInvoker methodInvokerForGetter = this.resolveGetterInvokerForField(targetType, propertyName, field);
        if (methodInvokerForGetter != null) {
            return methodInvokerForGetter;
        }
        Asserts.isFalse(this.throwIfNoAnyMatched, "No getter method found for property [{}] in [{}] ", propertyName, targetType.getName());
        return null;
    }

    @Override
    public @Nullable MethodInvoker findSetter(Class<?> targetType, String propertyName) {
        Method method = ReflectivePropertyOperator.findSetterMethod(targetType, propertyName);
        MethodInvoker methodInvoker = this.resolveInvokerForMethod(targetType, propertyName, method);
        if (methodInvoker != null) {
            return methodInvoker;
        }
        Field field = ReflectUtils.getField(targetType, propertyName);
        MethodInvoker methodInvokerForSetter = this.resolveSetterInvokerForField(targetType, propertyName, field);
        if (methodInvokerForSetter != null) {
            return methodInvokerForSetter;
        }
        Asserts.isFalse(this.throwIfNoAnyMatched, "No setter method found for property [{}] in [{}] ", propertyName, targetType.getName());
        return null;
    }

    protected final @Nullable MethodInvoker resolveInvokerForMethod(Class<?> targetType, String propertyName, @Nullable Method method) {
        if (Objects.isNull(method)) {
            return null;
        }
        MethodInvoker invoker = this.createInvokerForMethod(targetType, propertyName, method);
        if (Objects.isNull(invoker)) {
            return null;
        }
        if (Objects.isNull(this.converterManager)) {
            return invoker;
        }
        return ParameterConvertibleMethodInvoker.create(invoker, this.converterManager, method.getParameterTypes());
    }

    protected @Nullable MethodInvoker createInvokerForMethod(Class<?> targetType, String propertyName, Method method) {
        return ReflectiveMethodInvoker.create(null, method, false);
    }

    protected final @Nullable MethodInvoker resolveSetterInvokerForField(Class<?> targetType, String propertyName, @Nullable Field field) {
        if (Objects.isNull(field)) {
            return null;
        }
        MethodInvoker invoker = this.createSetterInvokerForField(targetType, propertyName, field);
        if (Objects.isNull(invoker)) {
            return null;
        }
        if (Objects.isNull(this.converterManager)) {
            return invoker;
        }
        return ParameterConvertibleMethodInvoker.create(invoker, this.converterManager, new Class[]{field.getType()});
    }

    protected MethodInvoker createSetterInvokerForField(Class<?> targetType, String propertyName, Field field) {
        return ReflectiveFieldAdapterMethodInvoker.createSetter(field);
    }

    protected final MethodInvoker resolveGetterInvokerForField(Class<?> targetType, String propertyName, @Nullable Field field) {
        if (Objects.isNull(field)) {
            return null;
        }
        return this.createGetterInvokerForField(targetType, propertyName, field);
    }

    protected MethodInvoker createGetterInvokerForField(Class<?> targetType, String propertyName, Field field) {
        return ReflectiveFieldAdapterMethodInvoker.createGetter(field);
    }

    private static @Nullable Method findSetterMethod(Class<?> targetType, String propertyName) {
        Field field = ReflectUtils.getField(targetType, propertyName);
        if (Objects.isNull(field)) {
            return ReflectUtils.findSetterMethod(targetType, propertyName).orElse(null);
        }
        return ReflectUtils.findSetterMethod(targetType, field).orElse(null);
    }

    private static @Nullable Method findGetterMethod(Class<?> targetType, String propertyName) {
        Field field = ReflectUtils.getField(targetType, propertyName);
        if (Objects.isNull(field)) {
            return ReflectUtils.findGetterMethod(targetType, propertyName).orElse(null);
        }
        return ReflectUtils.findGetterMethod(targetType, field).orElse(null);
    }

    public void setConverterManager(@Nullable ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public void setThrowIfNoAnyMatched(boolean throwIfNoAnyMatched) {
        this.throwIfNoAnyMatched = throwIfNoAnyMatched;
    }
}

