/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.util;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ArrayUtils {
    public static <T> T getFirstNotNull(T ... array) {
        if (Objects.isNull(array)) {
            return null;
        }
        for (T t : array) {
            if (!Objects.nonNull(t)) continue;
            return t;
        }
        return null;
    }

    @SafeVarargs
    public static <T> T[] append(T[] array, T ... elements) {
        if (Objects.isNull(array)) {
            return elements;
        }
        if (ArrayUtils.isEmpty(elements)) {
            return Arrays.copyOf(array, array.length);
        }
        T[] result = Arrays.copyOf(array, array.length + elements.length);
        System.arraycopy(elements, 0, result, array.length, elements.length);
        return result;
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNotEmpty(Object[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static <T> String join(T[] array, Function<T, String> mapper, String delimiter) {
        if (Objects.isNull(array)) {
            return "";
        }
        return ArrayUtils.stream(array).map(mapper).collect(Collectors.joining(delimiter));
    }

    public static String join(String[] array, String delimiter) {
        return ArrayUtils.join(array, Function.identity(), delimiter);
    }

    public static <T> boolean contains(T[] array, T target) {
        if (Objects.isNull(array)) {
            return false;
        }
        return Arrays.asList(array).contains(target);
    }

    public static <T> Stream<T> stream(T[] array) {
        if (Objects.isNull(array)) {
            return Stream.empty();
        }
        return Stream.of(array);
    }

    public static <T> T get(T[] array, int index) {
        if (Objects.isNull(array)) {
            return null;
        }
        if (index < 0 || index >= array.length) {
            return null;
        }
        return array[index];
    }

    public static <T> int length(T[] array) {
        if (Objects.isNull(array)) {
            return 0;
        }
        return array.length;
    }

    public static <T, U> boolean isEquals(T[] array1, U[] array2) {
        return ArrayUtils.isEquals(array1, array2, Objects::equals);
    }

    public static <T, U> boolean isEquals(T[] array1, U[] array2, BiPredicate<T, U> predicate) {
        if (array1 == array2) {
            return true;
        }
        if (array1 == null || array2 == null) {
            return false;
        }
        int length = array1.length;
        if (length != array2.length) {
            return false;
        }
        predicate = Objects.requireNonNull(predicate, "predicate must not null").negate();
        for (int i = 0; i < length; ++i) {
            T o1 = array1[i];
            U o2 = array2[i];
            if (!predicate.test(o1, o2)) continue;
            return false;
        }
        return true;
    }

    private ArrayUtils() {
    }
}

