/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.util;

import cn.crane4j.core.util.StandardMultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;

public interface MultiMap<K, V> {
    public static <K, V> MultiMap<K, V> arrayListMultimap() {
        return new StandardMultiMap(new HashMap(8), ArrayList::new);
    }

    public static <K, V> MultiMap<K, V> linkedListMultimap() {
        return new StandardMultiMap(new LinkedHashMap(), ArrayList::new);
    }

    public static <K, V> MultiMap<K, V> linkedHashMultimap() {
        return new StandardMultiMap(new LinkedHashMap(), LinkedHashSet::new);
    }

    public int size();

    public boolean isEmpty();

    public boolean containsKey(Object var1);

    public boolean put(K var1, V var2);

    public void putAll(K var1, Iterable<? extends V> var2);

    public void putAll(MultiMap<K, V> var1);

    public Collection<V> removeAll(Object var1);

    public void clear();

    public Collection<V> get(K var1);

    public Set<K> keySet();

    public Collection<V> values();

    public Collection<Map.Entry<K, V>> entries();

    default public void forEach(BiConsumer<? super K, ? super V> action) {
        this.asMap().forEach((k, vs) -> vs.forEach((? super T v) -> action.accept((Object)k, (Object)v)));
    }

    public Map<K, Collection<V>> asMap();

    public boolean equals(Object var1);

    public int hashCode();
}

