/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.util;

import cn.crane4j.core.exception.Crane4jException;
import cn.crane4j.core.support.AnnotationFinder;
import cn.crane4j.core.support.ParameterNameFinder;
import cn.crane4j.core.util.ArrayUtils;
import cn.crane4j.core.util.ClassUtils;
import cn.crane4j.core.util.CollectionUtils;
import cn.crane4j.core.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ReflectUtils {
    private static final String SET_PREFIX = "set";
    private static final String IS_PREFIX = "is";
    private static final String GET_PREFIX = "get";
    private static final Object[] EMPTY_PARAMS = new Object[0];
    private static final Map<Class<?>, Field[]> DECLARED_FIELD_CACHE = CollectionUtils.newWeakConcurrentMap();
    private static final Map<Class<?>, Field[]> FIELD_CACHE = CollectionUtils.newWeakConcurrentMap();
    private static final Map<Class<?>, Method[]> DECLARED_METHOD_CACHE = CollectionUtils.newWeakConcurrentMap();
    private static final Map<Class<?>, Method[]> METHOD_CACHE = CollectionUtils.newWeakConcurrentMap();
    private static final Map<Class<?>, Set<Class<?>>> DECLARED_SUPER_CLASS_WITH_INTERFACE = CollectionUtils.newWeakConcurrentMap();

    public static <T> T invokeRaw(Object object, Method method, Object ... args) {
        ReflectUtils.setAccessible(method);
        try {
            return (T)method.invoke(object, args);
        }
        catch (Exception e) {
            throw new Crane4jException(e);
        }
    }

    public static <T> T invoke(Object object, Method method, Object ... args) {
        Object[] actualArguments = ReflectUtils.resolveMethodInvocationArguments(method, args);
        return ReflectUtils.invokeRaw(object, method, actualArguments);
    }

    public static Object[] resolveMethodInvocationArguments(Method method, Object ... args) {
        int parameterCount = method.getParameterCount();
        if (parameterCount == 0) {
            return EMPTY_PARAMS;
        }
        if (ArrayUtils.isEmpty(args)) {
            return new Object[parameterCount];
        }
        if (parameterCount == args.length) {
            return args;
        }
        Parameter[] parameters = method.getParameters();
        Object[] actualArguments = new Object[parameterCount];
        int newLen = Math.min(parameters.length, args.length);
        System.arraycopy(args, 0, actualArguments, 0, newLen);
        return actualArguments;
    }

    public static Map<String, Parameter> resolveParameterNames(ParameterNameFinder finder, Method method) {
        Object[] parameters = method.getParameters();
        String[] parameterNames = finder.getParameterNames(method);
        if (ArrayUtils.isEmpty(parameters)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Parameter> parameterMap = new LinkedHashMap<String, Parameter>(parameters.length);
        int nameLength = ArrayUtils.length(parameterNames);
        for (int i = 0; i < parameters.length; ++i) {
            Object parameter = parameters[i];
            String parameterName = nameLength <= i ? ((Parameter)parameter).getName() : parameterNames[i];
            parameterMap.put(parameterName, (Parameter)parameter);
        }
        return parameterMap;
    }

    public static Method[] getDeclaredMethods(Class<?> type) {
        return CollectionUtils.computeIfAbsent(DECLARED_METHOD_CACHE, type, k -> type.getDeclaredMethods());
    }

    public static @Nullable Method getDeclaredMethod(Class<?> type, String methodName, Class<?> ... parameterTypes) {
        return ReflectUtils.findSpecificMethod(ReflectUtils.getDeclaredMethods(type), methodName, parameterTypes);
    }

    public static Method[] getMethods(Class<?> type) {
        return CollectionUtils.computeIfAbsent(METHOD_CACHE, type, curr -> {
            ArrayList methods = new ArrayList();
            ReflectUtils.traverseTypeHierarchy(curr, t -> methods.addAll(Arrays.asList(ReflectUtils.getDeclaredMethods(t))));
            return methods.toArray(new Method[0]);
        });
    }

    public static @Nullable Method getMethod(Class<?> type, String methodName, Class<?> ... parameterTypes) {
        return ReflectUtils.findSpecificMethod(ReflectUtils.getMethods(type), methodName, parameterTypes);
    }

    private static Method findSpecificMethod(Method[] methods, String methodName, Class<?>[] parameterTypes) {
        Predicate<Method> predicate = method -> method.getName().equals(methodName);
        if (Objects.nonNull(parameterTypes)) {
            predicate = parameterTypes.length > 0 ? predicate.and(method -> Arrays.equals(method.getParameterTypes(), parameterTypes)) : predicate.and(method -> method.getParameterCount() == 0);
        }
        return Stream.of(methods).filter(predicate).findFirst().orElse(null);
    }

    public static Optional<Method> findGetterMethod(Class<?> beanType, Field field) {
        Class<?> fieldType = field.getType();
        if (Boolean.TYPE.equals(fieldType) || Boolean.class.equals(fieldType)) {
            String booleanGetterName = StringUtils.upperFirstAndAddPrefix(field.getName(), IS_PREFIX);
            return Optional.ofNullable(ReflectUtils.getMethod(beanType, booleanGetterName, new Class[0]));
        }
        String getterName = StringUtils.upperFirstAndAddPrefix(field.getName(), GET_PREFIX);
        Method method = ReflectUtils.getMethod(beanType, getterName, new Class[0]);
        if (Objects.nonNull(method)) {
            return Optional.of(method);
        }
        getterName = field.getName();
        return Optional.ofNullable(ReflectUtils.getMethod(beanType, getterName, new Class[0]));
    }

    public static Optional<Method> findGetterMethod(Class<?> beanType, String fieldName) {
        String getterName = StringUtils.upperFirstAndAddPrefix(fieldName, GET_PREFIX);
        Method method = ReflectUtils.getMethod(beanType, getterName, new Class[0]);
        if (Objects.nonNull(method)) {
            return Optional.of(method);
        }
        Optional<Method> fluentGetter = Optional.ofNullable(ReflectUtils.getMethod(beanType, fieldName, new Class[0]));
        if (fluentGetter.isPresent()) {
            return fluentGetter;
        }
        String booleanGetterName = StringUtils.upperFirstAndAddPrefix(fieldName, IS_PREFIX);
        return Optional.ofNullable(ReflectUtils.getMethod(beanType, booleanGetterName, new Class[0]));
    }

    public static Optional<Method> findSetterMethod(Class<?> beanType, Field field) {
        Class<?> fieldType = field.getType();
        String setterName = StringUtils.upperFirstAndAddPrefix(field.getName(), SET_PREFIX);
        Method method = ReflectUtils.getMethod(beanType, setterName, fieldType);
        if (Objects.nonNull(method)) {
            return Optional.of(method);
        }
        setterName = field.getName();
        method = ReflectUtils.getMethod(beanType, setterName, fieldType);
        if (Objects.nonNull(method)) {
            return Optional.of(method);
        }
        String booleanSetterName = StringUtils.upperFirstAndAddPrefix(field.getName(), IS_PREFIX);
        return Optional.ofNullable(ReflectUtils.getMethod(beanType, booleanSetterName, fieldType));
    }

    public static Optional<Method> findSetterMethod(Class<?> beanType, String fieldName) {
        String setterName = StringUtils.upperFirstAndAddPrefix(fieldName, SET_PREFIX);
        Optional<Method> method = ReflectUtils.findMethod(beanType, setterName, 1);
        if (method.isPresent()) {
            return method;
        }
        Optional<Method> fluentSetter = ReflectUtils.findMethod(beanType, fieldName, 1);
        if (fluentSetter.isPresent()) {
            return fluentSetter;
        }
        String booleanSetterName = StringUtils.upperFirstAndAddPrefix(fieldName, IS_PREFIX);
        return ReflectUtils.findMethod(beanType, booleanSetterName, 1);
    }

    public static Optional<Method> findMethod(Class<?> beanType, String methodName, int parameterCount) {
        Method[] methods = ReflectUtils.getMethods(beanType);
        return Stream.of(methods).filter(m -> m.getName().equals(methodName)).filter(m -> m.getParameterCount() == parameterCount).findFirst();
    }

    public static boolean isJdkElement(AnnotatedElement element) {
        Class<?> checkedClass = element.getClass();
        if (element instanceof Class) {
            checkedClass = (Class<?>)element;
            if (checkedClass.isPrimitive()) {
                return true;
            }
        } else if (element instanceof Member) {
            checkedClass = ((Member)((Object)element)).getDeclaringClass();
        }
        return ClassUtils.isJdkClass(checkedClass);
    }

    public static <A extends Annotation, E extends AnnotatedElement> void scanAllAnnotationFromElements(AnnotationFinder annotationFinder, Class<A> annotationType, E[] elements, BiConsumer<E, A> consumer) {
        if (ArrayUtils.isEmpty(elements)) {
            return;
        }
        for (Object element : elements) {
            Set<A> annotations = annotationFinder.getAllAnnotations((AnnotatedElement)element, annotationType);
            if (CollectionUtils.isEmpty(annotations)) continue;
            annotations.forEach(a -> consumer.accept(element, a));
        }
    }

    public static Set<Class<?>> getDeclaredSuperClassWithInterface(Class<?> type) {
        return CollectionUtils.computeIfAbsent(DECLARED_SUPER_CLASS_WITH_INTERFACE, type, k -> {
            LinkedHashSet result = new LinkedHashSet();
            Class superClass = type.getSuperclass();
            if (superClass != null) {
                result.add(superClass);
            }
            result.addAll(Arrays.asList(type.getInterfaces()));
            return result;
        });
    }

    public static void traverseTypeHierarchy(Class<?> beanType, Consumer<Class<?>> consumer) {
        HashSet<Class> accessed = new HashSet<Class>();
        LinkedList typeQueue = new LinkedList();
        typeQueue.add(beanType);
        while (!typeQueue.isEmpty()) {
            Class type = (Class)typeQueue.removeFirst();
            accessed.add(type);
            consumer.accept(type);
            Set declaredSuperClassWithInterface = ReflectUtils.getDeclaredSuperClassWithInterface(type);
            declaredSuperClassWithInterface.remove(Object.class);
            declaredSuperClassWithInterface.removeAll(accessed);
            CollectionUtils.addAll(typeQueue, declaredSuperClassWithInterface);
        }
    }

    public static @Nullable Field getDeclaredField(Class<?> type, String fieldName) {
        return Stream.of(ReflectUtils.getDeclaredFields(type)).filter(f -> Objects.equals(f.getName(), fieldName)).findFirst().orElse(null);
    }

    public static Field[] getDeclaredFields(Class<?> type) {
        return CollectionUtils.computeIfAbsent(DECLARED_FIELD_CACHE, type, Class::getDeclaredFields);
    }

    public static @Nullable Field getField(Class<?> type, String fieldName) {
        return Stream.of(ReflectUtils.getFields(type)).filter(f -> Objects.equals(f.getName(), fieldName)).findFirst().orElse(null);
    }

    public static Field[] getFields(Class<?> type) {
        return CollectionUtils.computeIfAbsent(FIELD_CACHE, type, t -> {
            ArrayList fields = new ArrayList();
            ReflectUtils.traverseTypeHierarchy(t, curr -> fields.addAll(Arrays.asList(ReflectUtils.getDeclaredFields(curr))));
            return fields.toArray(new Field[0]);
        });
    }

    public static <T> @Nullable T getFieldValue(Object target, String fieldName) {
        Field field = ReflectUtils.getField(target.getClass(), fieldName);
        return Objects.isNull(field) ? null : (T)ReflectUtils.getFieldValue(target, field);
    }

    public static <T> T getFieldValue(Object target, Field field) {
        Objects.requireNonNull(field, "field must not null");
        ReflectUtils.setAccessible(field);
        try {
            return (T)field.get(target);
        }
        catch (Exception e) {
            throw new Crane4jException(e);
        }
    }

    public static <T extends AccessibleObject> void setAccessible(T accessibleObject) {
        if (!accessibleObject.isAccessible()) {
            accessibleObject.setAccessible(true);
        }
    }

    private ReflectUtils() {
    }
}

