/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.util;

import cn.crane4j.core.util.MultiMap;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class StandardMultiMap<K, V, C extends Collection<V>>
implements MultiMap<K, V> {
    private final Map<K, C> rawMap;
    private final Supplier<C> collectionFactory;

    @Override
    public int size() {
        return this.rawMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rawMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.rawMap.containsKey(o);
    }

    @Override
    public boolean put(K k, V v) {
        return this.rawMap.computeIfAbsent(k, key -> (Collection)this.collectionFactory.get()).add(v);
    }

    @Override
    public void putAll(K k, Iterable<? extends V> iterable) {
        iterable.forEach((? super T v) -> this.put(k, v));
    }

    @Override
    public void putAll(MultiMap<K, V> multiMap) {
        multiMap.asMap().forEach(this::putAll);
    }

    @Override
    public Collection<V> removeAll(Object o) {
        Collection values = (Collection)this.rawMap.remove(o);
        return values == null ? Collections.emptyList() : values;
    }

    @Override
    public void clear() {
        this.rawMap.clear();
    }

    @Override
    public Collection<V> get(K k) {
        return (Collection)this.rawMap.getOrDefault(k, this.collectionFactory.get());
    }

    @Override
    public Set<K> keySet() {
        return this.rawMap.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.rawMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public Collection<Map.Entry<K, V>> entries() {
        return this.rawMap.entrySet().stream().flatMap(e -> ((Collection)e.getValue()).stream().map(v -> new AbstractMap.SimpleEntry(e.getKey(), v))).collect(Collectors.toList());
    }

    @Override
    public Map<K, Collection<V>> asMap() {
        return this.rawMap;
    }

    public StandardMultiMap(Map<K, C> rawMap, Supplier<C> collectionFactory) {
        this.rawMap = rawMap;
        this.collectionFactory = collectionFactory;
    }
}

