/*
 * Decompiled with CFR 0.152.
 */
package cn.crane4j.core.util;

import cn.crane4j.core.util.ArrayUtils;
import java.util.Objects;

public class StringUtils {
    public static boolean contains(CharSequence str, CharSequence searchStr) {
        if (Objects.isNull(str) && Objects.isNull(searchStr)) {
            return false;
        }
        if (Objects.equals(str, searchStr)) {
            return true;
        }
        if (Objects.isNull(str) || Objects.isNull(searchStr)) {
            return false;
        }
        return str.toString().contains(searchStr);
    }

    public static String format(String template, Object ... args) {
        if (StringUtils.isEmpty(template) || ArrayUtils.isEmpty(args)) {
            return template;
        }
        StringBuilder sb = new StringBuilder();
        int cursor = 0;
        int index = 0;
        while (cursor < template.length()) {
            int placeholderIndex = template.indexOf("{}", cursor);
            if (placeholderIndex == -1) {
                sb.append(template.substring(cursor));
                break;
            }
            sb.append(template, cursor, placeholderIndex);
            if (index < args.length) {
                sb.append(args[index++]);
            } else {
                sb.append("{}");
            }
            cursor = placeholderIndex + 2;
        }
        return sb.toString();
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !StringUtils.isEmpty(cs);
    }

    public static String emptyToDefault(String str, String defaultStr) {
        return StringUtils.isEmpty(str) ? defaultStr : str;
    }

    public static String emptyToNull(String str) {
        return StringUtils.isEmpty(str) ? null : str;
    }

    public static String upperFirstAndAddPrefix(String str, String prefix) {
        return prefix + StringUtils.upperFirst(str);
    }

    public static String upperFirst(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        char[] charArray = str.toCharArray();
        charArray[0] = Character.toUpperCase(charArray[0]);
        return new String(charArray);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    private StringUtils() {
    }
}

