/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.util;

import cn.dev33.satoken.exception.SaTokenException;
import java.io.Console;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public class SaFoxUtil {
    public static String URL_REGEX = "(https?|ftp|file)://[-A-Za-z0-9+&@#/%?=~_|!:,.;]+[-A-Za-z0-9+&@#/%=~_|]";
    public static List<String> logLevelList = Arrays.asList("", "trace", "debug", "info", "warn", "error", "fatal");

    private SaFoxUtil() {
    }

    public static void printSaToken() {
        String str = "____ ____    ___ ____ _  _ ____ _  _ \r\n[__  |__| __  |  |  | |_/  |___ |\\ | \r\n___] |  |     |  |__| | \\_ |___ | \\| \r\nhttps://sa-token.cc (v1.44.0)";
        System.out.println(str);
    }

    public static String getRandomString(int length) {
        String str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int number = ThreadLocalRandom.current().nextInt(62);
            sb.append(str.charAt(number));
        }
        return sb.toString();
    }

    public static int getRandomNumber(int min, int max) {
        return ThreadLocalRandom.current().nextInt(min, max + 1);
    }

    public static boolean isEmpty(Object str) {
        return str == null || "".equals(str);
    }

    public static boolean isNotEmpty(Object str) {
        return !SaFoxUtil.isEmpty(str);
    }

    @Deprecated
    public static <T> boolean isEmpty(T[] array) {
        return SaFoxUtil.isEmptyArray(array);
    }

    public static <T> boolean isEmptyArray(T[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmptyList(List<?> list) {
        return list == null || list.isEmpty();
    }

    public static boolean equals(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static boolean notEquals(Object a, Object b) {
        return !SaFoxUtil.equals(a, b);
    }

    public static String getMarking28() {
        return System.currentTimeMillis() + "" + ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE);
    }

    public static String formatDate(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
    }

    public static String formatDate(ZonedDateTime zonedDateTime) {
        return zonedDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public static String formatAfterDate(long ms) {
        Instant instant = Instant.ofEpochMilli(System.currentTimeMillis() + ms);
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
        return SaFoxUtil.formatDate(zonedDateTime);
    }

    public static List<String> searchList(Collection<String> dataList, String prefix, String keyword, int start, int size, boolean sortType) {
        if (prefix == null) {
            prefix = "";
        }
        if (keyword == null) {
            keyword = "";
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String key : dataList) {
            if (!key.startsWith(prefix) || !key.contains(keyword)) continue;
            list.add(key);
        }
        return SaFoxUtil.searchList(list, start, size, sortType);
    }

    public static List<String> searchList(List<String> list, int start, int size, boolean sortType) {
        if (!sortType) {
            Collections.reverse(list);
        }
        if (start < 0) {
            start = 0;
        }
        int end = size == -1 ? list.size() : start + size;
        ArrayList<String> list2 = new ArrayList<String>();
        for (int i = start; i < end; ++i) {
            if (i >= list.size()) {
                return list2;
            }
            list2.add(list.get(i));
        }
        return list2;
    }

    public static boolean vagueMatch(String patt, String str) {
        if (patt == null && str == null) {
            return true;
        }
        if (patt == null || str == null) {
            return false;
        }
        if (!patt.contains("*")) {
            return patt.equals(str);
        }
        return SaFoxUtil.vagueMatchMethod(patt, str);
    }

    private static boolean vagueMatchMethod(String pattern, String str) {
        int i;
        int m = str.length();
        int n = pattern.length();
        boolean[][] dp = new boolean[m + 1][n + 1];
        dp[0][0] = true;
        for (i = 1; i <= n && pattern.charAt(i - 1) == '*'; ++i) {
            dp[0][i] = true;
        }
        for (i = 1; i <= m; ++i) {
            for (int j = 1; j <= n; ++j) {
                if (pattern.charAt(j - 1) == '*') {
                    dp[i][j] = dp[i][j - 1] || dp[i - 1][j];
                    continue;
                }
                if (str.charAt(i - 1) != pattern.charAt(j - 1)) continue;
                dp[i][j] = dp[i - 1][j - 1];
            }
        }
        return dp[m][n];
    }

    public static boolean isWrapperType(Class<?> cs) {
        return cs == Integer.class || cs == Short.class || cs == Long.class || cs == Byte.class || cs == Float.class || cs == Double.class || cs == Boolean.class || cs == Character.class;
    }

    public static boolean isBasicType(Class<?> cs) {
        return cs.isPrimitive() || SaFoxUtil.isWrapperType(cs) || cs == String.class;
    }

    public static <T> T getValueByType(Object obj, Class<T> cs) {
        if (obj == null || obj.getClass().equals(cs)) {
            return (T)obj;
        }
        String obj2 = String.valueOf(obj);
        Object obj3 = cs.equals(String.class) ? obj2 : (cs.equals(Integer.TYPE) || cs.equals(Integer.class) ? Integer.valueOf(obj2) : (cs.equals(Long.TYPE) || cs.equals(Long.class) ? Long.valueOf(obj2) : (cs.equals(Short.TYPE) || cs.equals(Short.class) ? Short.valueOf(obj2) : (cs.equals(Byte.TYPE) || cs.equals(Byte.class) ? Byte.valueOf(obj2) : (cs.equals(Float.TYPE) || cs.equals(Float.class) ? Float.valueOf(obj2) : (cs.equals(Double.TYPE) || cs.equals(Double.class) ? Double.valueOf(obj2) : (cs.equals(Boolean.TYPE) || cs.equals(Boolean.class) ? Boolean.valueOf(obj2) : (cs.equals(Character.TYPE) || cs.equals(Character.class) ? Character.valueOf(obj2.charAt(0)) : obj))))))));
        return (T)obj3;
    }

    public static <T> T mapToObject(Map<String, Object> map, Class<T> clazz) {
        if (map == null) {
            return null;
        }
        if (clazz == Map.class) {
            return (T)map;
        }
        try {
            T obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field field : clazz.getDeclaredFields()) {
                String fieldName = field.getName();
                if (!map.containsKey(fieldName)) continue;
                field.setAccessible(true);
                field.set(obj, map.get(fieldName));
            }
            return obj;
        }
        catch (Exception e) {
            throw new RuntimeException("\u8f6c\u6362\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    public static String joinParam(String url, String paramStr) {
        int index;
        if (paramStr == null || paramStr.length() == 0) {
            return url;
        }
        if (url == null) {
            url = "";
        }
        if ((index = url.lastIndexOf(63)) == -1) {
            return url + '?' + paramStr;
        }
        if (index == url.length() - 1) {
            return url + paramStr;
        }
        if (index < url.length() - 1) {
            String separatorChar = "&";
            if (url.lastIndexOf(separatorChar) != url.length() - 1 && paramStr.indexOf(separatorChar) != 0) {
                return url + separatorChar + paramStr;
            }
            return url + paramStr;
        }
        return url;
    }

    public static String joinParam(String url, String key, Object value) {
        if (SaFoxUtil.isEmpty(url) || SaFoxUtil.isEmpty(key)) {
            return url;
        }
        return SaFoxUtil.joinParam(url, key + "=" + value);
    }

    public static String joinSharpParam(String url, String paramStr) {
        int index;
        if (paramStr == null || paramStr.length() == 0) {
            return url;
        }
        if (url == null) {
            url = "";
        }
        if ((index = url.lastIndexOf(35)) == -1) {
            return url + '#' + paramStr;
        }
        if (index == url.length() - 1) {
            return url + paramStr;
        }
        if (index < url.length() - 1) {
            String separatorChar = "&";
            if (url.lastIndexOf(separatorChar) != url.length() - 1 && paramStr.indexOf(separatorChar) != 0) {
                return url + separatorChar + paramStr;
            }
            return url + paramStr;
        }
        return url;
    }

    public static String joinSharpParam(String url, String key, Object value) {
        if (SaFoxUtil.isEmpty(url) || SaFoxUtil.isEmpty(key)) {
            return url;
        }
        return SaFoxUtil.joinSharpParam(url, key + "=" + value);
    }

    public static String spliceTwoUrl(String url1, String url2) {
        if (url1 == null) {
            return url2;
        }
        if (url2 == null) {
            return url1;
        }
        if (url2.startsWith("http")) {
            return url2;
        }
        return url1 + url2;
    }

    public static String arrayJoin(String[] arr) {
        if (arr == null) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            str.append(arr[i]);
            if (i == arr.length - 1) continue;
            str.append(",");
        }
        return str.toString();
    }

    public static boolean isUrl(String str) {
        if (SaFoxUtil.isEmpty(str)) {
            return false;
        }
        return str.toLowerCase().matches(URL_REGEX);
    }

    public static String encodeUrl(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SaTokenException(e).setCode(12103);
        }
    }

    public static String decoderUrl(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SaTokenException(e).setCode(12104);
        }
    }

    public static List<String> convertStringToList(String str) {
        String[] arr;
        ArrayList<String> list = new ArrayList<String>();
        if (SaFoxUtil.isEmpty(str)) {
            return list;
        }
        for (String s : arr = str.split(",")) {
            if (SaFoxUtil.isEmpty(s = s.trim())) continue;
            list.add(s);
        }
        return list;
    }

    public static String convertListToString(List<?> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            str.append(list.get(i));
            if (i == list.size() - 1) continue;
            str.append(",");
        }
        return str.toString();
    }

    public static String[] convertStringToArray(String str) {
        List<String> list = SaFoxUtil.convertStringToList(str);
        return list.toArray(new String[0]);
    }

    public static String convertArrayToString(String[] arr) {
        if (arr == null || arr.length == 0) {
            return "";
        }
        return String.join((CharSequence)",", arr);
    }

    public static <T> List<T> emptyList() {
        return new ArrayList();
    }

    public static List<String> toList(String ... str) {
        return new ArrayList<String>(Arrays.asList(str));
    }

    public static String[] toArray(List<String> list) {
        return list.toArray(new String[0]);
    }

    public static int translateLogLevelToInt(String level) {
        int levelInt = logLevelList.indexOf(level);
        if (levelInt <= 0 || levelInt >= logLevelList.size()) {
            levelInt = 1;
        }
        return levelInt;
    }

    public static String translateLogLevelToString(int level) {
        if (level <= 0 || level >= logLevelList.size()) {
            level = 1;
        }
        return logLevelList.get(level);
    }

    public static boolean isCanColorLog() {
        Console console = System.console();
        String term = System.getenv().get("TERM");
        if (console == null && term == null) {
            return true;
        }
        if (console != null && term != null) {
            return true;
        }
        if (console != null && term == null) {
            return false;
        }
        if (console == null && term != null) {
            return false;
        }
        return false;
    }

    public static boolean list1ContainList2AllElement(List<String> list1, List<String> list2) {
        if (list2 == null || list2.isEmpty()) {
            return true;
        }
        if (list1 == null || list1.isEmpty()) {
            return false;
        }
        for (String str : list2) {
            if (list1.contains(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean list1ContainList2AnyElement(List<String> list1, List<String> list2) {
        if (list1 == null || list1.isEmpty() || list2 == null || list2.isEmpty()) {
            return false;
        }
        for (String str : list2) {
            if (!list1.contains(str)) continue;
            return true;
        }
        return false;
    }

    public static List<String> list1RemoveByList2(List<String> list1, List<String> list2) {
        if (list1 == null) {
            return null;
        }
        if (list1.isEmpty() || list2 == null || list2.isEmpty()) {
            return new ArrayList<String>(list1);
        }
        ArrayList<String> listX = new ArrayList<String>(list1);
        for (String str : list2) {
            listX.remove(str);
        }
        return listX;
    }

    public static boolean hasNonPrintableASCII(String str) {
        if (str == null) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c > '\u001f' && c != '\u007f') continue;
            return true;
        }
        return false;
    }

    public static String valueToString(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }
}

