/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.servlet.model;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.util.SaFoxUtil;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class SaRequestForServlet
implements SaRequest {
    protected HttpServletRequest request;

    public SaRequestForServlet(HttpServletRequest request) {
        this.request = request;
    }

    public Object getSource() {
        return this.request;
    }

    public String getParam(String name) {
        return this.request.getParameter(name);
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public String getCookieValue(String name) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie == null || !name.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public String getRequestPath() {
        return this.request.getServletPath();
    }

    public String getUrl() {
        String currDomain = SaManager.getConfig().getCurrDomain();
        if (!SaFoxUtil.isEmpty((Object)currDomain)) {
            return currDomain + this.getRequestPath();
        }
        return this.request.getRequestURL().toString();
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public Object forward(String path) {
        try {
            HttpServletResponse response = (HttpServletResponse)SaManager.getSaTokenContextOrSecond().getResponse().getSource();
            this.request.getRequestDispatcher(path).forward((ServletRequest)this.request, (ServletResponse)response);
            return null;
        }
        catch (ServletException | IOException e) {
            throw new SaTokenException(e).setCode(20001);
        }
    }
}

