/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.access.sms.processor;

import cn.herodotus.engine.access.core.definition.AccessHandler;
import cn.herodotus.engine.access.core.definition.AccessResponse;
import cn.herodotus.engine.access.core.definition.AccessUserDetails;
import cn.herodotus.engine.access.core.exception.AccessIdentityVerificationFailedException;
import cn.herodotus.engine.access.sms.stamp.VerificationCodeStampManager;
import cn.herodotus.engine.assistant.definition.domain.oauth2.AccessPrincipal;
import cn.herodotus.engine.cache.core.exception.StampHasExpiredException;
import cn.herodotus.engine.cache.core.exception.StampMismatchException;
import cn.herodotus.engine.cache.core.exception.StampParameterIllegalException;
import java.util.LinkedHashMap;
import org.dromara.sms4j.api.SmsBlend;
import org.dromara.sms4j.api.entity.SmsResponse;
import org.dromara.sms4j.core.factory.SmsFactory;

public class PhoneNumberAccessHandler
implements AccessHandler {
    private final VerificationCodeStampManager verificationCodeStampManager;

    public PhoneNumberAccessHandler(VerificationCodeStampManager verificationCodeStampManager) {
        this.verificationCodeStampManager = verificationCodeStampManager;
    }

    public AccessResponse preProcess(String phone, String ... params) {
        boolean result;
        String code = (String)this.verificationCodeStampManager.create(phone);
        if (this.verificationCodeStampManager.getSandbox().booleanValue()) {
            result = true;
        } else {
            SmsBlend smsBlend = SmsFactory.getSmsBlend();
            LinkedHashMap<String, String> message = new LinkedHashMap<String, String>();
            message.put("code", code);
            SmsResponse smsResponse = smsBlend.sendMessage(phone, this.verificationCodeStampManager.getVerificationCodeTemplateId(), message);
            result = smsResponse.isSuccess();
        }
        AccessResponse accessResponse = new AccessResponse();
        accessResponse.setSuccess(Boolean.valueOf(result));
        return accessResponse;
    }

    public AccessUserDetails loadUserDetails(String source, AccessPrincipal accessPrincipal) {
        try {
            this.verificationCodeStampManager.check(accessPrincipal.getMobile(), accessPrincipal.getCode());
            AccessUserDetails accessUserDetails = new AccessUserDetails();
            accessUserDetails.setUuid(accessPrincipal.getMobile());
            accessUserDetails.setPhoneNumber(accessPrincipal.getMobile());
            accessUserDetails.setUsername(accessPrincipal.getMobile());
            accessUserDetails.setSource(source);
            this.verificationCodeStampManager.delete(accessPrincipal.getMobile());
            return accessUserDetails;
        }
        catch (StampHasExpiredException | StampMismatchException | StampParameterIllegalException e) {
            throw new AccessIdentityVerificationFailedException("Phone Verification Code Error!");
        }
    }
}

