/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.captcha.behavior.renderer;

import cn.herodotus.engine.captcha.behavior.definition.AbstractBehaviorRenderer;
import cn.herodotus.engine.captcha.behavior.dto.WordClickCaptcha;
import cn.herodotus.engine.captcha.behavior.renderer.WordClickObfuscator;
import cn.herodotus.engine.captcha.core.definition.domain.Coordinate;
import cn.herodotus.engine.captcha.core.definition.domain.Metadata;
import cn.herodotus.engine.captcha.core.definition.enums.CaptchaCategory;
import cn.herodotus.engine.captcha.core.definition.enums.FontStyle;
import cn.herodotus.engine.captcha.core.dto.Captcha;
import cn.herodotus.engine.captcha.core.dto.Verification;
import cn.herodotus.engine.captcha.core.exception.CaptchaHasExpiredException;
import cn.herodotus.engine.captcha.core.exception.CaptchaMismatchException;
import cn.herodotus.engine.captcha.core.exception.CaptchaParameterIllegalException;
import cn.herodotus.engine.captcha.core.provider.RandomProvider;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.dromara.hutool.core.data.id.IdUtil;
import org.springframework.stereotype.Component;

@Component
public class WordClickCaptchaRenderer
extends AbstractBehaviorRenderer<String, List<Coordinate>> {
    private WordClickCaptcha wordClickCaptcha;

    public WordClickCaptchaRenderer() {
        super("cache:token:captcha:word_click:");
    }

    private Font getFont() {
        int fontSize = this.getCaptchaProperties().getWordClick().getFontSize();
        String fontName = this.getCaptchaProperties().getWordClick().getFontName();
        FontStyle fontStyle = this.getCaptchaProperties().getWordClick().getFontStyle();
        return this.getResourceProvider().getFont(fontName, fontSize, fontStyle);
    }

    public String getCategory() {
        return CaptchaCategory.WORD_CLICK.getConstant();
    }

    public List<Coordinate> nextStamp(String key) {
        Metadata metadata = this.draw();
        WordClickObfuscator wordClickObfuscator = new WordClickObfuscator(metadata.getWords(), metadata.getCoordinates());
        WordClickCaptcha wordClickCaptcha = new WordClickCaptcha();
        wordClickCaptcha.setIdentity(key);
        wordClickCaptcha.setWordClickImageBase64(metadata.getWordClickImageBase64());
        wordClickCaptcha.setWords(wordClickObfuscator.getWordString());
        wordClickCaptcha.setWordsCount(metadata.getWords().size());
        this.wordClickCaptcha = wordClickCaptcha;
        return wordClickObfuscator.getCoordinates();
    }

    public Captcha getCapcha(String key) {
        String identity = key;
        if (StringUtils.isBlank((CharSequence)identity)) {
            identity = IdUtil.fastUUID();
        }
        this.create(identity);
        return this.wordClickCaptcha;
    }

    public boolean verify(Verification verification) {
        if (ObjectUtils.isEmpty((Object)verification) || CollectionUtils.isEmpty((Collection)verification.getCoordinates())) {
            throw new CaptchaParameterIllegalException("Parameter Stamp value is null");
        }
        List store = (List)this.get(verification.getIdentity());
        if (CollectionUtils.isEmpty((Collection)store)) {
            throw new CaptchaHasExpiredException("Stamp is invalid!");
        }
        this.delete(verification.getIdentity());
        List real = verification.getCoordinates();
        for (int i = 0; i < store.size(); ++i) {
            if (!this.isDeflected(((Coordinate)real.get(i)).getX(), ((Coordinate)store.get(i)).getX(), this.getFontSize()) && !this.isDeflected(((Coordinate)real.get(i)).getX(), ((Coordinate)store.get(i)).getX(), this.getFontSize())) continue;
            throw new CaptchaMismatchException();
        }
        return true;
    }

    public Metadata draw() {
        BufferedImage backgroundImage = this.getResourceProvider().getRandomWordClickImage();
        int wordCount = this.getCaptchaProperties().getWordClick().getWordCount();
        List words = RandomProvider.randomWords((int)wordCount);
        Graphics backgroundGraphics = backgroundImage.getGraphics();
        int backgroundImageWidth = backgroundImage.getWidth();
        int backgroundImageHeight = backgroundImage.getHeight();
        List coordinates = IntStream.range(0, words.size()).mapToObj(index -> this.drawWord(backgroundGraphics, backgroundImageWidth, backgroundImageHeight, index, wordCount, (String)words.get(index))).collect(Collectors.toList());
        this.addWatermark(backgroundGraphics, backgroundImageWidth, backgroundImageHeight);
        BufferedImage combinedImage = new BufferedImage(backgroundImageWidth, backgroundImageHeight, 1);
        Graphics combinedGraphics = combinedImage.getGraphics();
        combinedGraphics.drawImage(backgroundImage, 0, 0, null);
        int excludeWordIndex = RandomProvider.randomInt((int)1, (int)wordCount) - 1;
        words.remove(excludeWordIndex);
        coordinates.remove(excludeWordIndex);
        Metadata metadata = new Metadata();
        metadata.setWordClickImageBase64(this.toBase64(backgroundImage));
        metadata.setCoordinates(coordinates);
        metadata.setWords(words);
        return metadata;
    }

    private Coordinate drawWord(Graphics graphics, int width, int height, int index, int wordCount, String word) {
        Coordinate coordinate = this.randomWordCoordinate(width, height, index, wordCount);
        if (this.getCaptchaProperties().getWordClick().isRandomColor()) {
            graphics.setColor(new Color(RandomProvider.randomInt((int)1, (int)255), RandomProvider.randomInt((int)1, (int)255), RandomProvider.randomInt((int)1, (int)255)));
        } else {
            graphics.setColor(Color.BLACK);
        }
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(Math.toRadians(RandomProvider.randomInt((int)-45, (int)45)), 0.0, 0.0);
        Font rotatedFont = this.getFont().deriveFont(affineTransform);
        graphics.setFont(rotatedFont);
        graphics.drawString(word, coordinate.getX(), coordinate.getY());
        return coordinate;
    }

    private int getFontSize() {
        return this.getCaptchaProperties().getWordClick().getFontSize();
    }

    private int getHalfFontSize() {
        return this.getFontSize() / 2;
    }

    private Coordinate randomWordCoordinate(int backgroundImageWidth, int backgroundImageHeight, int wordIndex, int wordCount) {
        int wordSize = this.getFontSize();
        int averageWidth = backgroundImageWidth / (wordCount + 1);
        int halfWordSize = this.getHalfFontSize();
        int x = averageWidth < halfWordSize ? RandomProvider.randomInt((int)this.getStartInclusive(halfWordSize), (int)backgroundImageWidth) : (wordIndex == 0 ? RandomProvider.randomInt((int)this.getStartInclusive(halfWordSize), (int)this.getEndExclusive(wordIndex, averageWidth, halfWordSize)) : RandomProvider.randomInt((int)(averageWidth * wordIndex + halfWordSize), (int)this.getEndExclusive(wordIndex, averageWidth, halfWordSize)));
        int y = RandomProvider.randomInt((int)wordSize, (int)(backgroundImageHeight - wordSize));
        return new Coordinate(x, y);
    }

    private int getStartInclusive(int halfWordSize) {
        return 1 + halfWordSize;
    }

    private int getEndExclusive(int wordIndex, int averageWidth, int halfWordSize) {
        return averageWidth * (wordIndex + 1) - halfWordSize;
    }
}

