/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.cloud.client;

import cn.hiboot.mcn.cloud.client.RestClientProperties;
import cn.hiboot.mcn.cloud.client.RestTemplateBuilderCustomizer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.client.RestTemplateAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.cloud.client.loadbalancer.LoadBalanced;
import org.springframework.context.annotation.Bean;
import org.springframework.web.client.RestTemplate;

@AutoConfiguration(after={RestTemplateAutoConfiguration.class})
@EnableConfigurationProperties(value={RestClientProperties.class})
@ConditionalOnClass(value={RestTemplate.class})
@ConditionalOnBean(value={RestTemplateBuilder.class})
@ConditionalOnProperty(prefix="rest.client", name={"enable"}, havingValue="true", matchIfMissing=true)
public class RestClientAutoConfiguration {
    private final RestClientProperties properties;
    private final ObjectProvider<RestTemplateBuilderCustomizer> restTemplateBuilderCustomizers;

    public RestClientAutoConfiguration(RestClientProperties properties, ObjectProvider<RestTemplateBuilderCustomizer> restTemplateBuilderCustomizers) {
        this.properties = properties;
        this.restTemplateBuilderCustomizers = restTemplateBuilderCustomizers;
    }

    @Bean
    @ConditionalOnMissingBean(name={"restTemplate"})
    RestTemplate restTemplate(RestTemplateBuilder builder) {
        return this.restTemplate0(builder);
    }

    private RestTemplate restTemplate0(RestTemplateBuilder builder) {
        builder.setReadTimeout(this.properties.getReadTimeout());
        builder.setConnectTimeout(this.properties.getConnectTimeout());
        this.restTemplateBuilderCustomizers.orderedStream().forEachOrdered(b -> b.custom(builder));
        return builder.build();
    }

    @Bean
    @LoadBalanced
    @ConditionalOnClass(name={"org.springframework.cloud.client.loadbalancer.LoadBalanced"})
    @ConditionalOnMissingBean(name={"loadBalancedRestTemplate"})
    RestTemplate loadBalancedRestTemplate(RestTemplateBuilder builder) {
        return this.restTemplate0(builder);
    }
}

