/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.cloud.discover;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnNotWebApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.cloud.client.serviceregistry.AbstractAutoServiceRegistration;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.web.context.WebApplicationContext;

@AutoConfiguration
@ConditionalOnSingleCandidate(value=AbstractAutoServiceRegistration.class)
@AutoConfigureOrder(value=0x7FFFFFFF)
@Conditional(value={ServiceRegisterCondition.class})
@Import(value={ServiceRegisterConfig.class})
public class ServiceRegisterAutoConfiguration {

    static class OnWarDeploymentCondition
    implements Condition {
        OnWarDeploymentCondition() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            ResourceLoader resourceLoader;
            if (ClassUtils.isPresent((String)"org.springframework.web.context.WebApplicationContext", (ClassLoader)context.getClassLoader()) && (resourceLoader = context.getResourceLoader()) instanceof WebApplicationContext) {
                WebApplicationContext applicationContext = (WebApplicationContext)resourceLoader;
                return applicationContext.getServletContext() != null;
            }
            return false;
        }
    }

    static class ServiceRegisterCondition
    extends AnyNestedCondition {
        ServiceRegisterCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnClass(name={"com.huaweicloud.servicecomb.discovery.registry.ServiceCombAutoServiceRegistration"})
        @ConditionalOnNotWebApplication
        static class CseServiceEngine {
            CseServiceEngine() {
            }
        }

        @Conditional(value={OnWarDeploymentCondition.class})
        static class WarDeploy {
            WarDeploy() {
            }
        }
    }

    static class ServiceRegisterConfig
    implements BeanPostProcessor {
        ServiceRegisterConfig() {
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof AbstractAutoServiceRegistration) {
                ((AbstractAutoServiceRegistration)bean).start();
            }
            return bean;
        }
    }
}

