/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.cloud.encryptor.jackson;

import cn.hiboot.mcn.cloud.encryptor.DecryptDataConverter;
import cn.hiboot.mcn.cloud.encryptor.sm2.TextEncryptor;
import cn.hiboot.mcn.core.exception.ServiceException;
import cn.hiboot.mcn.core.util.SpringBeanUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.springframework.core.convert.ConversionService;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class DecryptDataSerializer
extends StdDeserializer<Object> {
    private final Class<? extends DecryptDataConverter> converter;
    private final TextEncryptor textEncryptor = (TextEncryptor)SpringBeanUtils.getBean(TextEncryptor.class);
    private final ConversionService conversionService = (ConversionService)SpringBeanUtils.getBean(ConversionService.class);

    public DecryptDataSerializer(Class<?> type, Class<? extends DecryptDataConverter> converter) {
        super(type);
        this.converter = converter;
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (this.converter != DecryptDataConverter.class) {
            try {
                DecryptDataConverter decryptDataConverter = (DecryptDataConverter)ReflectionUtils.accessibleConstructor(this.converter, (Class[])new Class[0]).newInstance(new Object[0]);
                return decryptDataConverter.apply(p, this.textEncryptor);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw ServiceException.newInstance((String)"DecryptData Converter newInstance Failed", (Throwable)e);
            }
            catch (IOException e) {
                throw ServiceException.newInstance((String)"Jackson deserialize Failed", (Throwable)e);
            }
            catch (Exception e) {
                throw ServiceException.newInstance((String)"DecryptData Converter Failed", (Throwable)e);
            }
        }
        String currentValue = p.getText();
        if (ObjectUtils.isEmpty((Object)currentValue)) {
            return currentValue;
        }
        try {
            currentValue = this.textEncryptor.decrypt(currentValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.conversionService.convert((Object)currentValue, this.handledType());
    }
}

