/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.cloud.encryptor.jackson;

import cn.hiboot.mcn.cloud.encryptor.sm2.TextEncryptor;
import cn.hiboot.mcn.core.util.SpringBeanUtils;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Objects;
import org.springframework.beans.BeanUtils;

public class EncryptDataSerializer
extends StdSerializer<Object> {
    private final TextEncryptor textEncryptor = (TextEncryptor)SpringBeanUtils.getBean(TextEncryptor.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public EncryptDataSerializer() {
        super(Object.class);
    }

    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (Objects.isNull(value)) {
            return;
        }
        String rs = value.toString();
        if (!BeanUtils.isSimpleProperty(value.getClass())) {
            rs = objectMapper.writeValueAsString(value);
        }
        gen.writeString(this.textEncryptor.encrypt(rs));
    }
}

