/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.cloud.encryptor.sm2;

import cn.hiboot.mcn.cloud.encryptor.sm2.SM2Encryptor;
import cn.hiboot.mcn.cloud.encryptor.sm2.TextEncryptor;
import cn.hiboot.mcn.cloud.encryptor.sm4.EncryptorProperties;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import org.bouncycastle.util.encoders.Hex;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={SymmetricCrypto.class, Hex.class})
@EnableConfigurationProperties(value={EncryptorProperties.class})
@ConditionalOnProperty(prefix="encryptor.sm2", name={"private-key", "public-key"})
public class SM2AutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    TextEncryptor sm2Encryptor(EncryptorProperties encryptorProperties) {
        return new SM2Encryptor(encryptorProperties);
    }
}

