/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.cloud.encryptor.sm2;

import cn.hiboot.mcn.cloud.encryptor.sm2.TextEncryptor;
import cn.hiboot.mcn.cloud.encryptor.sm4.EncryptorProperties;
import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.SM2;
import org.bouncycastle.crypto.engines.SM2Engine;

public class SM2Encryptor
implements TextEncryptor {
    private final EncryptorProperties.SM2 config;
    private final boolean continueOnError;
    private final SM2 sm2;

    public SM2Encryptor(EncryptorProperties encryptorProperties) {
        this.continueOnError = encryptorProperties.isContinueOnError();
        this.config = encryptorProperties.getSm2();
        this.sm2 = SmUtil.sm2((String)this.config.getPrivateKey(), (String)this.config.getPublicKey());
        this.sm2.setMode(SM2Engine.Mode.valueOf((String)this.config.getMode().name()));
    }

    @Override
    public String encrypt(String text) {
        try {
            String encryptBcd = this.config.isBase64() ? this.sm2.encryptBase64(text, KeyType.PublicKey) : (this.config.isBcd() ? this.sm2.encryptBcd(text, KeyType.PublicKey) : this.sm2.encryptHex(text, KeyType.PublicKey));
            return this.config.isLowerCase() ? encryptBcd.toLowerCase() : encryptBcd;
        }
        catch (Exception e) {
            if (!this.continueOnError) {
                throw e;
            }
            return text;
        }
    }

    @Override
    public String decrypt(String text) {
        try {
            String decryptStr = this.config.isBcd() ? this.sm2.decryptStrFromBcd(text, KeyType.PrivateKey) : this.sm2.decryptStr(text, KeyType.PrivateKey);
            return decryptStr;
        }
        catch (Exception e) {
            if (!this.continueOnError) {
                throw e;
            }
            return text;
        }
    }

    public String publicKey() {
        return HexUtil.encodeHexStr((byte[])this.sm2.getQ(false));
    }

    public String privateKey() {
        return this.sm2.getDHex();
    }
}

