/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.cloud.encryptor.sm4;

import cn.hiboot.mcn.cloud.encryptor.sm4.EncryptorProperties;
import cn.hutool.crypto.Mode;
import cn.hutool.crypto.Padding;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.symmetric.SM4;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import com.sgitg.sgcc.sm.SM4Utils;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.annotation.Order;
import org.springframework.security.crypto.encrypt.TextEncryptor;

@AutoConfiguration
@ConditionalOnClass(value={TextEncryptor.class})
@EnableConfigurationProperties(value={EncryptorProperties.class})
@Order(value=0)
@ConditionalOnProperty(prefix="encryptor.sm4", name={"key"})
public class SM4BootstrapConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={SM4Utils.class})
    @ConditionalOnProperty(prefix="encryptor.sm4", name={"mode"}, havingValue="cbc")
    @Import(value={SM4Encryptor.class})
    @ConditionalOnMissingBean(value={TextEncryptor.class})
    private static class SM4ExtendConfiguration {
        private SM4ExtendConfiguration() {
        }

        static class SM4Encryptor
        extends SM4Utils
        implements TextEncryptor {
            private final boolean continueOnError;
            private final byte[] key;
            private final byte[] iv;

            public SM4Encryptor(EncryptorProperties encryptorProperties) {
                this.continueOnError = encryptorProperties.isContinueOnError();
                this.key = this.generateKeyOrIV(encryptorProperties.getSm4().getKey());
                this.iv = this.generateKeyOrIV(encryptorProperties.getSm4().getIv());
            }

            private byte[] generateKeyOrIV(String str) {
                return Hex.encode((byte[])str.getBytes(StandardCharsets.UTF_8));
            }

            public String encrypt(String text) {
                try {
                    return new String(Hex.encode((byte[])this.encryptData_CBC(Hex.decode((byte[])this.iv), Hex.decode((byte[])this.key), Strings.toUTF8ByteArray((String)text))));
                }
                catch (Exception e) {
                    if (!this.continueOnError) {
                        throw e;
                    }
                    return text;
                }
            }

            public String decrypt(String encryptedText) {
                try {
                    return Strings.fromUTF8ByteArray((byte[])this.decryptData_CBC(Hex.decode((byte[])this.iv), Hex.decode((byte[])this.key), Hex.decode((String)encryptedText))).trim();
                }
                catch (Exception e) {
                    if (!this.continueOnError) {
                        throw e;
                    }
                    return encryptedText;
                }
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={SymmetricCrypto.class, Hex.class})
    @ConditionalOnMissingBean(value={TextEncryptor.class})
    private static class SM4Encryptor
    implements TextEncryptor {
        private final boolean base64;
        private final SymmetricCrypto sm4;
        private final boolean continueOnError;

        public SM4Encryptor(EncryptorProperties encryptorProperties) {
            this.continueOnError = encryptorProperties.isContinueOnError();
            EncryptorProperties.SM4 sm4 = encryptorProperties.getSm4();
            if (sm4.getMode() != null && sm4.getPadding() != null) {
                Mode mode = Mode.valueOf((String)sm4.getMode().name());
                Padding padding = Padding.valueOf((String)sm4.getPadding().name());
                this.sm4 = sm4.getIv() == null ? new SM4(mode, padding, sm4.getKey().getBytes(StandardCharsets.UTF_8)) : new SM4(mode, padding, sm4.getKey().getBytes(StandardCharsets.UTF_8), sm4.getIv().getBytes(StandardCharsets.UTF_8));
            } else {
                this.sm4 = SmUtil.sm4((byte[])sm4.getKey().getBytes(StandardCharsets.UTF_8));
            }
            this.base64 = encryptorProperties.getSm4().isBase64();
        }

        public String encrypt(String s) {
            try {
                return this.base64 ? this.sm4.encryptBase64(s) : this.sm4.encryptHex(s);
            }
            catch (Exception e) {
                if (!this.continueOnError) {
                    throw e;
                }
                return s;
            }
        }

        public String decrypt(String s) {
            try {
                return this.sm4.decryptStr(s);
            }
            catch (Exception e) {
                if (!this.continueOnError) {
                    throw e;
                }
                return s;
            }
        }
    }
}

