/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.cloud.encryptor.web;

import cn.hiboot.mcn.autoconfigure.web.filter.common.NameValueProcessor;
import cn.hiboot.mcn.autoconfigure.web.filter.common.NameValueProcessorProperties;
import cn.hiboot.mcn.autoconfigure.web.filter.common.reactive.ReactiveNameValueProcessorFilter;
import cn.hiboot.mcn.autoconfigure.web.filter.common.servlet.NameValueProcessorFilter;
import cn.hiboot.mcn.cloud.encryptor.sm2.SM2AutoConfiguration;
import cn.hiboot.mcn.cloud.encryptor.sm2.TextEncryptor;
import cn.hiboot.mcn.cloud.encryptor.web.DecryptConverter;
import cn.hiboot.mcn.cloud.encryptor.web.DecryptProperties;
import cn.hiboot.mcn.cloud.encryptor.web.DecryptRequestBodyAdvice;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.format.FormatterRegistry;
import org.springframework.web.reactive.config.WebFluxConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfiguration(after={SM2AutoConfiguration.class})
@ConditionalOnBean(value={TextEncryptor.class})
@EnableConfigurationProperties(value={DecryptProperties.class})
public class DecryptConverterAutoConfiguration {
    private static NameValueProcessor nameValueProcessor(TextEncryptor textEncryptor) {
        return (name, value) -> textEncryptor.decrypt(value);
    }

    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    static class ReactiveDecryptConverterConfiguration {
        ReactiveDecryptConverterConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(prefix="mcn.decrypt", name={"process-payload"}, havingValue="true")
        ReactiveNameValueProcessorFilter decryptReactiveNameValueProcessorFilter(DecryptProperties decryptProperties, TextEncryptor textEncryptor) {
            return new ReactiveNameValueProcessorFilter((NameValueProcessorProperties)decryptProperties, DecryptConverterAutoConfiguration.nameValueProcessor(textEncryptor));
        }

        @Configuration(proxyBeanMethods=false)
        private static class WebFluxConfig
        implements WebFluxConfigurer {
            private final TextEncryptor textEncryptor;

            public WebFluxConfig(TextEncryptor textEncryptor) {
                this.textEncryptor = textEncryptor;
            }

            public void addFormatters(FormatterRegistry registry) {
                registry.addConverter((GenericConverter)new DecryptConverter(this.textEncryptor, (ConversionService)registry));
            }
        }
    }

    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    @Import(value={DecryptRequestBodyAdvice.class})
    static class ServletDecryptConverterConfiguration {
        ServletDecryptConverterConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(prefix="mcn.decrypt", name={"process-payload"}, havingValue="true")
        FilterRegistrationBean<NameValueProcessorFilter> decryptFilterRegistration(DecryptProperties decryptProperties, TextEncryptor textEncryptor) {
            FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)new NameValueProcessorFilter((NameValueProcessorProperties)decryptProperties, DecryptConverterAutoConfiguration.nameValueProcessor(textEncryptor)), new ServletRegistrationBean[0]);
            filterRegistrationBean.setOrder(decryptProperties.getOrder());
            filterRegistrationBean.setName(decryptProperties.getName());
            return filterRegistrationBean;
        }

        @Configuration(proxyBeanMethods=false)
        private static class WebMvcConfig
        implements WebMvcConfigurer {
            private final TextEncryptor textEncryptor;

            public WebMvcConfig(TextEncryptor textEncryptor) {
                this.textEncryptor = textEncryptor;
            }

            public void addFormatters(FormatterRegistry registry) {
                registry.addConverter((GenericConverter)new DecryptConverter(this.textEncryptor, (ConversionService)registry));
            }
        }
    }
}

