/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.cloud.encryptor.web;

import cn.hiboot.mcn.cloud.encryptor.Decrypt;
import cn.hiboot.mcn.cloud.encryptor.sm2.TextEncryptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.StreamUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;

@ControllerAdvice
public class DecryptRequestBodyAdvice
implements RequestBodyAdvice {
    private final TextEncryptor encryptor;

    public DecryptRequestBodyAdvice(TextEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public boolean supports(MethodParameter methodParameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return methodParameter.hasParameterAnnotation(Decrypt.class);
    }

    public HttpInputMessage beforeBodyRead(final HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        return new HttpInputMessage(){

            public InputStream getBody() throws IOException {
                String encryptData = DecryptRequestBodyAdvice.this.encryptor.decrypt(StreamUtils.copyToString((InputStream)inputMessage.getBody(), (Charset)StandardCharsets.UTF_8));
                return new ByteArrayInputStream(encryptData.getBytes(StandardCharsets.UTF_8));
            }

            public HttpHeaders getHeaders() {
                return inputMessage.getHeaders();
            }
        };
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public Object handleEmptyBody(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return null;
    }
}

