/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.cloud.feign;

import cn.hiboot.mcn.autoconfigure.web.filter.common.NameValueProcessorJacksonConfig;
import cn.hiboot.mcn.cloud.feign.FeignCircuitBreakerTargeter;
import cn.hiboot.mcn.cloud.feign.FeignInterceptorConfiguration;
import feign.Feign;
import feign.FeignException;
import feign.Response;
import feign.codec.Decoder;
import feign.codec.ErrorDecoder;
import feign.optionals.OptionalDecoder;
import java.io.IOException;
import java.lang.reflect.Type;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.http.HttpMessageConverters;
import org.springframework.cloud.circuitbreaker.resilience4j.Resilience4JCircuitBreakerFactory;
import org.springframework.cloud.client.circuitbreaker.CircuitBreakerFactory;
import org.springframework.cloud.openfeign.CircuitBreakerNameResolver;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.cloud.openfeign.Targeter;
import org.springframework.cloud.openfeign.support.HttpMessageConverterCustomizer;
import org.springframework.cloud.openfeign.support.ResponseEntityDecoder;
import org.springframework.cloud.openfeign.support.SpringDecoder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Import;

@AutoConfiguration(before={FeignAutoConfiguration.class})
@ConditionalOnClass(value={Feign.class})
@Import(value={FeignInterceptorConfiguration.class})
public class FeignExtensionAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="param.processor", name={"enable"}, havingValue="true")
    public Decoder feignDecoder(ObjectProvider<HttpMessageConverterCustomizer> customizers, ObjectFactory<HttpMessageConverters> messageConverters) {
        return new OptionalDecoder((Decoder)new ResponseEntityDecoder((Decoder)new FeignClientResponseInterceptor(messageConverters, customizers)));
    }

    static class GlobalFallbackCondition
    extends AllNestedConditions {
        GlobalFallbackCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(prefix="feign.circuitbreaker", name={"globalfallback.enabled"}, havingValue="true", matchIfMissing=true)
        static class FeignGlobalCircuitbreakerEnabled {
            FeignGlobalCircuitbreakerEnabled() {
            }
        }

        @ConditionalOnProperty(prefix="feign.circuitbreaker", name={"enabled"}, havingValue="true")
        static class FeignCircuitbreakerEnabled {
            FeignCircuitbreakerEnabled() {
            }
        }
    }

    static class FeignClientResponseInterceptor
    extends SpringDecoder {
        public FeignClientResponseInterceptor(ObjectFactory<HttpMessageConverters> messageConverters, ObjectProvider<HttpMessageConverterCustomizer> customizers) {
            super(messageConverters, customizers);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object decode(Response response, Type type) throws IOException, FeignException {
            try {
                Object object = super.decode(response, type);
                return object;
            }
            finally {
                NameValueProcessorJacksonConfig.removeFeignRequest();
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ErrorDecoder.class})
    @ConditionalOnMissingBean(value={ErrorDecoder.class})
    protected static class FeignErrorDecoder
    implements ErrorDecoder {
        protected FeignErrorDecoder() {
        }

        public Exception decode(String methodKey, Response response) {
            return FeignException.errorStatus((String)methodKey, (Response)response);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={Resilience4JCircuitBreakerFactory.class})
    @Conditional(value={GlobalFallbackCondition.class})
    protected static class CircuitBreakerConfiguration {
        protected CircuitBreakerConfiguration() {
        }

        @Bean
        public Targeter circuitBreakerFeignTargeter(CircuitBreakerFactory circuitBreakerFactory, @Value(value="${feign.circuitbreaker.group.enabled:false}") boolean circuitBreakerGroupEnabled, CircuitBreakerNameResolver circuitBreakerNameResolver) {
            return new FeignCircuitBreakerTargeter(circuitBreakerFactory, circuitBreakerGroupEnabled, circuitBreakerNameResolver);
        }
    }
}

