/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.cloud.feign;

import cn.hiboot.mcn.autoconfigure.web.filter.common.NameValueProcessorJacksonConfig;
import cn.hiboot.mcn.autoconfigure.web.filter.integrity.DataIntegrityUtils;
import cn.hiboot.mcn.cloud.security.SessionHolder;
import cn.hiboot.mcn.core.tuples.Triplet;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.DefaultAuthenticationEventPublisher;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

@Configuration(proxyBeanMethods=false)
public class FeignInterceptorConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={DefaultAuthenticationEventPublisher.class, JwtAuthenticationToken.class})
    private static class FeignRequestInterceptor
    implements RequestInterceptor {
        private FeignRequestInterceptor() {
        }

        public void apply(RequestTemplate requestTemplate) {
            String authorization = SessionHolder.getBearerToken();
            if (authorization != null) {
                requestTemplate.header("Authorization", new String[]{authorization});
            }
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="param.processor", name={"enable"}, havingValue="true")
    private static class ParamProcessorInterceptor
    implements RequestInterceptor {
        private ParamProcessorInterceptor() {
        }

        public void apply(RequestTemplate template) {
            NameValueProcessorJacksonConfig.setFeignRequest();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(prefix="data.integrity.interceptor", name={"enable"}, havingValue="true")
    private static class DataIntegrityFeignInterceptor
    implements RequestInterceptor {
        private DataIntegrityFeignInterceptor() {
        }

        public void apply(RequestTemplate template) {
            HashMap params = new HashMap();
            template.queries().forEach((k, v) -> {
                block0: {
                    Iterator iterator = v.iterator();
                    if (!iterator.hasNext()) break block0;
                    String value = (String)iterator.next();
                    params.put(k, value);
                }
            });
            String data = null;
            Collection ct = (Collection)template.headers().get("Content-Type");
            if (ct != null && "application/json".equals(new ArrayList(ct).get(0))) {
                data = new String(template.body(), StandardCharsets.UTF_8);
            }
            Triplet triplet = DataIntegrityUtils.signature(params, data);
            template.header("TSM", new String[]{(String)triplet.getValue0()});
            template.header("nonceStr", new String[]{(String)triplet.getValue1()});
            template.header("signature", new String[]{(String)triplet.getValue2()});
        }
    }
}

