/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.cloud.feign;

import cn.hiboot.mcn.core.model.result.RestResp;
import feign.FeignException;
import java.lang.reflect.Method;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.cglib.proxy.MethodProxy;

public class GlobalFallback<T>
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(GlobalFallback.class);
    private final Class<T> targetType;
    private final String targetName;
    private final Throwable cause;

    public GlobalFallback(Class<T> targetType, String targetName, Throwable cause) {
        this.targetType = targetType;
        this.targetName = targetName;
        this.cause = cause;
    }

    public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
        String errorMessage = this.cause.getMessage();
        log.error("GlobalFallback:[{}.{}] serviceId:[{}] message:[{}]", new Object[]{this.targetType.getName(), method.getName(), this.targetName, errorMessage});
        if (!(this.cause instanceof FeignException)) {
            return this.remoteError(errorMessage);
        }
        FeignException exception = (FeignException)this.cause;
        if (exception.contentUTF8().isEmpty()) {
            return this.remoteError(errorMessage);
        }
        return this.remoteError(exception.contentUTF8());
    }

    private RestResp<Object> remoteError(String msg) {
        return RestResp.error((Integer)900002, (String)msg);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalFallback that = (GlobalFallback)o;
        return this.targetType.equals(that.targetType);
    }

    public int hashCode() {
        return Objects.hash(this.targetType);
    }
}

