/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.cloud.gateway;

import cn.hiboot.mcn.autoconfigure.web.exception.handler.ExceptionHandler;
import cn.hiboot.mcn.autoconfigure.web.swagger.IgnoreApi;
import cn.hiboot.mcn.core.model.result.RestResp;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.gateway.config.GatewayAutoConfiguration;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@AutoConfiguration
@ConditionalOnClass(value={GatewayAutoConfiguration.class})
public class GatewayExtensionAutoConfiguration {

    @RestController
    @ConditionalOnProperty(prefix="gateway.fallback", name={"enabled"}, havingValue="true", matchIfMissing=true)
    protected static class DefaultFallbackRestController {
        private final ExceptionHandler exceptionHandler;

        public DefaultFallbackRestController(ExceptionHandler exceptionHandler) {
            this.exceptionHandler = exceptionHandler;
        }

        @IgnoreApi
        @RequestMapping(value={"fallback"})
        public Mono<RestResp<?>> fallback(ServerWebExchange exchange) {
            return Mono.fromSupplier(() -> {
                Throwable ex = (Throwable)exchange.getAttribute(ServerWebExchangeUtils.CIRCUITBREAKER_EXECUTION_EXCEPTION_ATTR);
                if (ex == null) {
                    return RestResp.error((Integer)900002);
                }
                Route route = (Route)exchange.getAttribute(ServerWebExchangeUtils.GATEWAY_ROUTE_ATTR);
                return this.handleException(ex, route == null ? "" : route.getUri().getHost());
            });
        }

        public RestResp<Throwable> handleException(Throwable exception, String additionMsg) {
            RestResp resp = this.exceptionHandler.handleException(exception);
            if (this.exceptionHandler.config().isReturnOriginExMsg()) {
                return resp;
            }
            resp.setErrorInfo(additionMsg + resp.getErrorInfo());
            return resp;
        }
    }
}

