/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.cloud.security;

import java.util.Collections;
import java.util.Map;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;

public interface SessionHolder {
    public static final String BEARER_PREFIX = "Bearer ";
    public static final String USER_NAME = "user_name";

    public static String getUserId() {
        Object value = SessionHolder.getUser().get("userId");
        return value == null ? null : value.toString();
    }

    public static Map<String, Object> getUser() {
        Jwt jwt = SessionHolder.getJwtToken();
        return jwt == null ? Collections.emptyMap() : jwt.getClaimAsMap(USER_NAME);
    }

    public static Map<String, Object> getClaims() {
        Jwt jwt = SessionHolder.getJwtToken();
        return jwt == null ? Collections.emptyMap() : jwt.getClaims();
    }

    public static String getBearerToken() {
        String token = SessionHolder.getJwtTokenString();
        return token == null ? null : BEARER_PREFIX.concat(token);
    }

    public static String getJwtTokenString() {
        Jwt jwt = SessionHolder.getJwtToken();
        return jwt == null ? null : jwt.getTokenValue();
    }

    public static Jwt getJwtToken() {
        JwtAuthenticationToken jwtAuthenticationToken = SessionHolder.getJwtAuthenticationToken();
        return jwtAuthenticationToken == null ? null : (Jwt)jwtAuthenticationToken.getToken();
    }

    public static JwtAuthenticationToken getJwtAuthenticationToken() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication instanceof JwtAuthenticationToken ? (JwtAuthenticationToken)authentication : null;
    }
}

