/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.cloud.security.configurer;

import cn.hiboot.mcn.cloud.security.configurer.AuthenticationReload;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;

public class ReloadAuthenticationConfigurer
extends AbstractHttpConfigurer<ReloadAuthenticationConfigurer, HttpSecurity> {
    public void configure(HttpSecurity http) throws Exception {
        ApplicationContext applicationContext = (ApplicationContext)http.getSharedObject(ApplicationContext.class);
        String[] authenticationReloadBeanNames = applicationContext.getBeanNamesForType(AuthenticationReload.class);
        if (authenticationReloadBeanNames.length == 1) {
            AuthenticationReload authenticationReload = (AuthenticationReload)applicationContext.getBean(authenticationReloadBeanNames[0], AuthenticationReload.class);
            http.addFilterBefore((request, response, chain) -> {
                Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
                if (authentication != null) {
                    Jwt jwt0;
                    Map oldPrincipal;
                    Map<String, Object> newPrincipal;
                    Object principal = authentication.getPrincipal();
                    if (principal instanceof Map) {
                        Map oldPrincipal2 = (Map)principal;
                        Map<String, Object> newPrincipal2 = authenticationReload.reload(oldPrincipal2);
                        if (newPrincipal2 != null) {
                            oldPrincipal2.putAll(newPrincipal2);
                        }
                    } else if (principal instanceof Jwt && (newPrincipal = authenticationReload.reload(oldPrincipal = (jwt0 = (Jwt)principal).getClaimAsMap("user_name"))) != null) {
                        oldPrincipal.putAll(newPrincipal);
                        HashMap<String, Map> claims = new HashMap<String, Map>(jwt0.getClaims());
                        claims.put("user_name", oldPrincipal);
                        JwtAuthenticationToken jwtAuthenticationToken = (JwtAuthenticationToken)authentication;
                        Jwt jwt = new Jwt(jwt0.getTokenValue(), jwt0.getIssuedAt(), jwt0.getExpiresAt(), jwt0.getHeaders(), claims);
                        JwtAuthenticationToken authenticationToken = new JwtAuthenticationToken(jwt, jwtAuthenticationToken.getAuthorities());
                        authenticationToken.setDetails(jwtAuthenticationToken.getDetails());
                        SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationToken);
                    }
                }
                chain.doFilter(request, response);
            }, AnonymousAuthenticationFilter.class);
        }
    }
}

