/*
 * Decompiled with CFR 0.152.
 */
package cn.hiboot.mcn.cloud.security.resource;

import cn.hiboot.mcn.autoconfigure.web.exception.HttpStatusCodeResolver;
import cn.hiboot.mcn.autoconfigure.web.exception.handler.ExceptionHandler;
import cn.hiboot.mcn.autoconfigure.web.mvc.ResponseUtils;
import cn.hiboot.mcn.autoconfigure.web.reactor.ServerHttpResponseUtils;
import cn.hiboot.mcn.cloud.security.configurer.AuthenticationReload;
import cn.hiboot.mcn.cloud.security.configurer.ReloadAuthenticationConfigurer;
import cn.hiboot.mcn.cloud.security.resource.LoginRsp;
import cn.hiboot.mcn.cloud.security.resource.ResourceServerProperties;
import cn.hiboot.mcn.cloud.security.resource.TokenResolver;
import cn.hiboot.mcn.core.exception.ServiceException;
import cn.hiboot.mcn.core.model.result.RestResp;
import cn.hiboot.mcn.core.util.McnUtils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.ConditionalOnDefaultWebSecurity;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.web.server.SecurityWebFiltersOrder;
import org.springframework.security.config.web.server.ServerHttpSecurity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.server.resource.BearerTokenAuthenticationToken;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationToken;
import org.springframework.security.oauth2.server.resource.web.BearerTokenResolver;
import org.springframework.security.oauth2.server.resource.web.DefaultBearerTokenResolver;
import org.springframework.security.oauth2.server.resource.web.server.ServerBearerTokenAuthenticationConverter;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.server.SecurityWebFilterChain;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@AutoConfiguration
@EnableConfigurationProperties(value={ResourceServerProperties.class})
@ConditionalOnClass(value={JwtAuthenticationToken.class})
@ConditionalOnProperty(value={"spring.security.oauth2.resourceserver.jwt.public-key-location"}, havingValue="classpath:config/public.txt")
public class ResourceServerAutoConfiguration {
    @Bean
    HttpStatusCodeResolver resourceServerHttpStatusCodeResolver() {
        return exception -> {
            if (exception instanceof AuthenticationException) {
                return 800401;
            }
            if (exception instanceof AccessDeniedException) {
                return 800403;
            }
            return null;
        };
    }

    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    static class ServletResourceServerConfiguration {
        private final ExceptionHandler exceptionHandler;

        ServletResourceServerConfiguration(ExceptionHandler exceptionHandler) {
            this.exceptionHandler = exceptionHandler;
        }

        @Bean
        @ConditionalOnDefaultWebSecurity
        SecurityFilterChain resourceServerSecurityFilterChain(HttpSecurity http, ResourceServerProperties ssoProperties) throws Exception {
            return (SecurityFilterChain)((HttpSecurity)((ReloadAuthenticationConfigurer)http.authorizeRequests(requests -> {
                if (McnUtils.isNotNullAndEmpty(ssoProperties.getAllowedPaths())) {
                    ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.antMatchers(ssoProperties.getAllowedPaths().toArray(new String[0]))).permitAll();
                }
                ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.anyRequest()).authenticated();
            }).oauth2ResourceServer(c -> {
                if (ssoProperties.isOpaqueToken()) {
                    c.opaqueToken();
                } else {
                    c.jwt();
                }
                c.accessDeniedHandler((request, response, accessDeniedException) -> this.handleException((RuntimeException)accessDeniedException, response)).authenticationEntryPoint((request, response, authException) -> this.handleException((RuntimeException)authException, response));
            }).apply((SecurityConfigurerAdapter)new ReloadAuthenticationConfigurer())).and()).build();
        }

        private void handleException(RuntimeException exception, HttpServletResponse response) {
            ResponseUtils.write((RestResp)this.exceptionHandler.handleException((Throwable)exception), (HttpServletResponse)response);
        }

        @Component
        static class CustomBearerTokenResolver
        implements BearerTokenResolver {
            private final TokenResolver tokenResolver;
            private final BearerTokenResolver defaultBearerTokenResolver;

            public CustomBearerTokenResolver(ObjectProvider<TokenResolver> beanProvider) {
                this.tokenResolver = (TokenResolver)beanProvider.getIfUnique();
                this.defaultBearerTokenResolver = new DefaultBearerTokenResolver();
            }

            public String resolve(HttpServletRequest request) {
                String tokenHeader = request.getHeader("Authorization");
                if (McnUtils.isNotNullAndEmpty((Object)tokenHeader)) {
                    return this.defaultBearerTokenResolver.resolve(request);
                }
                if (this.tokenResolver != null) {
                    RestResp<LoginRsp> login;
                    String name = this.tokenResolver.paramName();
                    String apk = request.getHeader(name);
                    if (McnUtils.isNullOrEmpty((Object)apk)) {
                        apk = request.getParameter(name);
                    }
                    if (McnUtils.isNotNullAndEmpty((Object)apk) && (login = this.tokenResolver.resolve(apk)).getData() != null) {
                        return ((LoginRsp)login.getData()).getToken().substring("Bearer".length()).trim();
                    }
                }
                return null;
            }
        }
    }

    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
    static class ReactiveResourceServerConfiguration {
        private final ExceptionHandler exceptionHandler;

        ReactiveResourceServerConfiguration(ExceptionHandler exceptionHandler) {
            this.exceptionHandler = exceptionHandler;
        }

        @Bean
        @ConditionalOnMissingBean(value={SecurityWebFilterChain.class})
        SecurityWebFilterChain resourceServerSecurityFilterChain(ServerHttpSecurity http, ResourceServerProperties ssoProperties, ObjectProvider<AuthenticationReload> authenticationReloads, ObjectProvider<TokenResolver> tokenResolvers) {
            authenticationReloads.ifUnique(authenticationReload -> http.addFilterBefore((WebFilter)new ReloadAuthenticationWebFilter((AuthenticationReload)authenticationReload), SecurityWebFiltersOrder.ANONYMOUS_AUTHENTICATION));
            return http.authorizeExchange(requests -> {
                if (McnUtils.isNotNullAndEmpty(ssoProperties.getAllowedPaths())) {
                    ((ServerHttpSecurity.AuthorizeExchangeSpec.Access)requests.pathMatchers(ssoProperties.getAllowedPaths().toArray(new String[0]))).permitAll();
                }
                requests.anyExchange().authenticated();
            }).oauth2ResourceServer(c -> {
                if (ssoProperties.isOpaqueToken()) {
                    c.opaqueToken();
                } else {
                    c.jwt();
                }
                c.accessDeniedHandler((exchange, accessDeniedException) -> this.handleException((RuntimeException)accessDeniedException, exchange.getResponse())).authenticationEntryPoint((exchange, authException) -> this.handleException((RuntimeException)authException, exchange.getResponse()));
                tokenResolvers.ifUnique(tokenResolver -> c.bearerTokenConverter((ServerAuthenticationConverter)new ServerBearerTokenAuthenticationConverter((TokenResolver)tokenResolver){
                    final /* synthetic */ TokenResolver val$tokenResolver;
                    {
                        this.val$tokenResolver = tokenResolver;
                    }

                    public Mono<Authentication> convert(ServerWebExchange exchange) {
                        ServerHttpRequest request = exchange.getRequest();
                        String tokenHeader = request.getHeaders().getFirst("Authorization");
                        if (McnUtils.isNotNullAndEmpty((Object)tokenHeader)) {
                            return super.convert(exchange);
                        }
                        return Mono.just((Object)this.val$tokenResolver.paramName()).flatMap(name -> {
                            String apk = request.getHeaders().getFirst(name);
                            if (McnUtils.isNullOrEmpty((Object)apk)) {
                                apk = request.getHeaders().getFirst(name);
                            }
                            String token = "";
                            RestResp<LoginRsp> login = this.val$tokenResolver.resolve(apk);
                            if (login.getData() != null) {
                                token = ((LoginRsp)login.getData()).getToken().substring("Bearer".length()).trim();
                            }
                            if (token.isEmpty()) {
                                return Mono.error((Throwable)ServiceException.newInstance((String)(name + "\u4e0d\u6b63\u786e")));
                            }
                            return Mono.just((Object)new BearerTokenAuthenticationToken(token));
                        });
                    }
                }));
            }).build();
        }

        private Mono<Void> handleException(RuntimeException exception, ServerHttpResponse response) {
            return ServerHttpResponseUtils.write((RestResp)this.exceptionHandler.handleException((Throwable)exception), (ServerHttpResponse)response);
        }

        static class ReloadAuthenticationWebFilter
        implements WebFilter {
            private final AuthenticationReload authenticationReload;

            public ReloadAuthenticationWebFilter(AuthenticationReload authenticationReload) {
                this.authenticationReload = authenticationReload;
            }

            public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
                return ReactiveSecurityContextHolder.getContext().filter(c -> c.getAuthentication() != null).flatMap(securityContext -> {
                    Jwt jwt0;
                    Map oldPrincipal;
                    Map<String, Object> newPrincipal;
                    Authentication authentication = securityContext.getAuthentication();
                    Object principal = authentication.getPrincipal();
                    if (principal instanceof Map) {
                        Map oldPrincipal2 = (Map)principal;
                        Map<String, Object> newPrincipal2 = this.authenticationReload.reload(oldPrincipal2);
                        if (newPrincipal2 != null) {
                            oldPrincipal2.putAll(newPrincipal2);
                        }
                    } else if (principal instanceof Jwt && (newPrincipal = this.authenticationReload.reload(oldPrincipal = (jwt0 = (Jwt)principal).getClaimAsMap("user_name"))) != null) {
                        oldPrincipal.putAll(newPrincipal);
                        HashMap<String, Map> claims = new HashMap<String, Map>(jwt0.getClaims());
                        claims.put("user_name", oldPrincipal);
                        JwtAuthenticationToken jwtAuthenticationToken = (JwtAuthenticationToken)authentication;
                        Jwt jwt = new Jwt(jwt0.getTokenValue(), jwt0.getIssuedAt(), jwt0.getExpiresAt(), jwt0.getHeaders(), claims);
                        JwtAuthenticationToken authenticationToken = new JwtAuthenticationToken(jwt, jwtAuthenticationToken.getAuthorities());
                        authenticationToken.setDetails(jwtAuthenticationToken.getDetails());
                        SecurityContextHolder.getContext().setAuthentication((Authentication)authenticationToken);
                    }
                    return Mono.empty();
                }).switchIfEmpty(chain.filter(exchange).then(Mono.empty())).then();
            }
        }
    }
}

