/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.design.observer;

import cn.hippo4j.common.design.observer.Observer;
import cn.hippo4j.common.design.observer.ObserverMessage;
import cn.hippo4j.common.toolkit.CollectionUtil;
import cn.hippo4j.common.toolkit.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractSubjectCenter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractSubjectCenter.class);
    private static final Map<String, List<Observer>> OBSERVERS_MAP = new ConcurrentHashMap<String, List<Observer>>();

    public static void register(Observer observer) {
        AbstractSubjectCenter.register(SubjectType.SPRING_CONTENT_REFRESHED.name(), observer);
    }

    public static void register(SubjectType subjectType, Observer observer) {
        AbstractSubjectCenter.register(subjectType.name(), observer);
    }

    public static void register(String subject, Observer observer) {
        if (StringUtil.isBlank(subject) || observer == null) {
            log.warn("Register observer. A string whose subject or observer is empty or empty.");
            return;
        }
        List<Observer> observers = OBSERVERS_MAP.get(subject);
        if (CollectionUtil.isEmpty(observers)) {
            observers = new ArrayList<Observer>();
        }
        observers.add(observer);
        OBSERVERS_MAP.put(subject, observers);
    }

    public static void remove(Observer observer) {
        AbstractSubjectCenter.remove(SubjectType.SPRING_CONTENT_REFRESHED.name(), observer);
    }

    public static void remove(String subject, Observer observer) {
        List<Observer> observers = OBSERVERS_MAP.get(subject);
        if (StringUtil.isBlank(subject) || CollectionUtil.isEmpty(observers) || observer == null) {
            log.warn("Remove observer. A string whose subject or observer is empty or empty.");
            return;
        }
        observers.remove(observer);
    }

    public static void notify(SubjectType subjectType, ObserverMessage observerMessage) {
        AbstractSubjectCenter.notify(subjectType.name(), observerMessage);
    }

    public static void notify(String subject, ObserverMessage observerMessage) {
        List<Observer> observers = OBSERVERS_MAP.get(subject);
        if (CollectionUtil.isEmpty(observers)) {
            log.warn("Under the subject, there is no observer group.");
            return;
        }
        observers.parallelStream().forEach(each -> {
            try {
                each.accept(observerMessage);
            }
            catch (Exception ex) {
                log.error("Notification subject: {} observer exception", (Object)subject);
            }
        });
    }

    public static enum SubjectType {
        SPRING_CONTENT_REFRESHED,
        CLEAR_CONFIG_CACHE;

    }
}

