/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.executor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;

public final class ThreadPoolManager {
    private Map<String, Map<String, Set<ExecutorService>>> resourcesManager;
    private Map<String, Object> lockers = new ConcurrentHashMap<String, Object>();
    private static final ThreadPoolManager INSTANCE = new ThreadPoolManager();

    public static ThreadPoolManager getInstance() {
        return INSTANCE;
    }

    private ThreadPoolManager() {
    }

    private void init() {
        this.resourcesManager = new ConcurrentHashMap<String, Map<String, Set<ExecutorService>>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String tenantId, String group, ExecutorService executor) {
        Object monitor;
        if (!this.resourcesManager.containsKey(tenantId)) {
            ThreadPoolManager threadPoolManager = this;
            synchronized (threadPoolManager) {
                this.lockers.put(tenantId, new Object());
            }
        }
        Object object = monitor = this.lockers.get(tenantId);
        synchronized (object) {
            Map<String, Set<ExecutorService>> map = this.resourcesManager.get(tenantId);
            if (map == null) {
                map = new HashMap<String, Set<ExecutorService>>();
                map.put(group, new HashSet());
                map.get(group).add(executor);
                this.resourcesManager.put(tenantId, map);
                return;
            }
            if (!map.containsKey(group)) {
                map.put(group, new HashSet());
            }
            map.get(group).add(executor);
        }
    }

    static {
        INSTANCE.init();
    }
}

