/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.extension.reducer;

import cn.hippo4j.common.extension.IExtension;
import cn.hippo4j.common.extension.reducer.Reducer;
import cn.hippo4j.common.extension.support.ReduceType;
import java.util.Objects;
import java.util.function.Predicate;
import lombok.NonNull;

public class FirstOf<Element>
extends Reducer<Element, Element> {
    private Predicate<Element> predicate;

    public FirstOf(@NonNull Predicate<Element> predicate) {
        Objects.requireNonNull(predicate);
        this.predicate = predicate;
    }

    @Override
    public ReduceType reducerType() {
        return ReduceType.FIRST;
    }

    @Override
    public Element reduce() {
        for (IExtension extension : this.realizations) {
            Object element = this.getCallback().apply(extension);
            if (null != this.predicate && !this.predicate.test(element)) continue;
            return element;
        }
        return null;
    }
}

