/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.extension.reducer;

import cn.hippo4j.common.extension.reducer.AllMatch;
import cn.hippo4j.common.extension.reducer.AnyMatch;
import cn.hippo4j.common.extension.reducer.FirstOf;
import cn.hippo4j.common.extension.reducer.None;
import cn.hippo4j.common.extension.reducer.Reducer;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import lombok.NonNull;

public class Reducers {
    public static <E> Reducer<E, List<E>> none() {
        return new None();
    }

    public static <E> Reducer<E, E> firstOf(@NonNull Predicate<E> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate is marked non-null but is null");
        }
        return new FirstOf<E>(predicate);
    }

    public static <E> Reducer<E, E> firstOfNotNull() {
        return new FirstOf<Object>(Objects::nonNull);
    }

    public static <E> Reducer<E, Boolean> anyMatch(Predicate<E> predicate) {
        return new AnyMatch<E>(predicate);
    }

    public static <E> Reducer<E, Boolean> allMatch(@NonNull Predicate<E> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate is marked non-null but is null");
        }
        return new AllMatch<E>(predicate);
    }
}

