/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.extension.support;

import cn.hippo4j.common.extension.IExtension;
import cn.hippo4j.common.extension.reducer.Reducer;
import cn.hippo4j.common.extension.reducer.Reducers;
import cn.hippo4j.common.extension.support.ExtensionCallback;
import cn.hippo4j.common.extension.support.ExtensionRegistry;
import cn.hippo4j.common.extension.support.ServiceLoaderRegistry;
import cn.hippo4j.common.toolkit.Assert;
import cn.hippo4j.common.toolkit.CollectionUtil;
import java.util.ArrayList;
import java.util.List;

public class ExtensionInvoker {
    private static final ExtensionRegistry registry = ExtensionRegistry.getInstance();

    public static <T extends IExtension, E> List<E> reduceExecute(Class<T> targetClz, ExtensionCallback<T, E> callback) {
        return ExtensionInvoker.reduceExecute(targetClz, callback, Reducers.none());
    }

    public static <T extends IExtension, E, R> R reduceExecute(Class<T> targetClz, ExtensionCallback<T, E> callback, Reducer<E, R> reducer) {
        Assert.isTrue(IExtension.class.isAssignableFrom(targetClz), "can not execute extension point. please implement base extension interface(" + IExtension.class.getName() + ") first.");
        List<IExtension> realizations = registry.find(targetClz);
        if (CollectionUtil.isEmpty(realizations)) {
            realizations = new ArrayList<T>(ServiceLoaderRegistry.getSingletonServiceInstances(targetClz));
        }
        Assert.notEmpty(realizations, "can not find any extension realizations with interface: " + targetClz.getName());
        reducer.setRealizations(realizations);
        reducer.setCallback(callback);
        return reducer.reduce();
    }
}

