/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.extension.support;

import cn.hippo4j.common.extension.IExtension;
import cn.hippo4j.common.extension.annotation.Realization;
import cn.hippo4j.common.extension.support.IExtensionRegistry;
import cn.hippo4j.common.toolkit.CollectionUtil;
import cn.hippo4j.common.toolkit.logtracing.LogMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.ClassUtils;

public class ExtensionRegistry
implements IExtensionRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtensionRegistry.class);
    private final Map<Class<? extends IExtension>, List<IExtension>> registry = new ConcurrentHashMap<Class<? extends IExtension>, List<IExtension>>();
    private static ExtensionRegistry INSTANCE;

    private ExtensionRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExtensionRegistry getInstance() {
        if (null != INSTANCE) return INSTANCE;
        Class<ExtensionRegistry> clazz = ExtensionRegistry.class;
        synchronized (ExtensionRegistry.class) {
            if (null != INSTANCE) return INSTANCE;
            INSTANCE = new ExtensionRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    @Override
    public void register(IExtension realization) {
        Class<?>[] interfaces;
        Class implClass = realization.getClass();
        if (AopUtils.isAopProxy(implClass)) {
            implClass = ClassUtils.getUserClass(implClass);
        }
        Realization annotation = implClass.getAnnotation(Realization.class);
        for (Class<?> intf : interfaces = implClass.getInterfaces()) {
            if (!IExtension.class.isAssignableFrom(intf)) continue;
            this.register(intf, realization);
        }
    }

    private void register(Class<? extends IExtension> extension, IExtension realization) {
        if (!this.registry.containsKey(extension) || CollectionUtil.isEmpty(this.registry.get(extension))) {
            ArrayList<IExtension> realizations = new ArrayList<IExtension>();
            realizations.add(realization);
            this.registry.put(extension, realizations);
        } else {
            if (this.registry.get(extension).contains(realization)) {
                log.warn(LogMessage.getInstance().kv("realizationClassName", realization.getClass().getName()).msg("Extension realization already registered, skip.", new Object[0]));
            }
            List<IExtension> realizations = this.registry.get(extension);
            realizations.add(realization);
            this.registry.put(extension, realizations);
        }
    }

    @Override
    public List<IExtension> find(Class<? extends IExtension> extension) {
        return this.registry.get(extension);
    }
}

