/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.toolkit;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.TimeZone;
import lombok.Generated;

public class DateUtil {
    private static final TimeZone TIME_ZONE = TimeZone.getDefault();
    public static final String NORM_DATE_PATTERN = "yyyy-MM-dd";
    public static final String NORM_TIME_PATTERN = "HH:mm:ss";
    public static final String NORM_DATETIME_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public static long getTime(LocalDateTime date) {
        return DateUtil.getTime(date, TIME_ZONE.toZoneId());
    }

    public static long getTime(LocalDateTime date, ZoneId zoneId) {
        return date.atZone(zoneId).toInstant().toEpochMilli();
    }

    public static String format(Date date, String normTimePattern) {
        SimpleDateFormat zoneFormat = new SimpleDateFormat(normTimePattern);
        return zoneFormat.format(date);
    }

    @Generated
    private DateUtil() {
    }
}

