/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.toolkit;

import org.springframework.util.StringUtils;

public class GroupKey {
    public static String getKey(String dataId, String group) {
        return GroupKey.getKey(dataId, group, "");
    }

    public static String getKey(String dataId, String group, String datumStr) {
        return GroupKey.doGetKey(dataId, group, datumStr);
    }

    public static String getKey(String ... params) {
        StringBuilder groupKey = new StringBuilder();
        groupKey.append(params[0]).append("+");
        for (int i = 1; i < params.length - 1; ++i) {
            groupKey.append(params[i]).append("+");
        }
        groupKey.append(params[params.length - 1]);
        return groupKey.toString();
    }

    public static String getKeyTenant(String dataId, String group, String tenant) {
        return GroupKey.doGetKey(dataId, group, tenant);
    }

    private static String doGetKey(String dataId, String group, String datumStr) {
        StringBuilder sb = new StringBuilder();
        GroupKey.urlEncode(dataId, sb);
        sb.append("+");
        GroupKey.urlEncode(group, sb);
        if (!StringUtils.isEmpty((Object)datumStr)) {
            sb.append("+");
            GroupKey.urlEncode(datumStr, sb);
        }
        return sb.toString();
    }

    public static String[] parseKey(String groupKey) {
        return groupKey.split("\\+");
    }

    public static void urlEncode(String str, StringBuilder sb) {
        for (int idx = 0; idx < str.length(); ++idx) {
            char c = str.charAt(idx);
            if ('+' == c) {
                sb.append("%2B");
                continue;
            }
            if ('%' == c) {
                sb.append("%25");
                continue;
            }
            sb.append(c);
        }
    }
}

