/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.toolkit;

import cn.hippo4j.common.toolkit.ArrayUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    public static final String EMPTY = "";
    public static final char UNDERLINE = '_';
    public static final String[] EMPTY_ARRAY = new String[0];

    public static String emptyToNull(String str) {
        return str == null || str.isEmpty() ? null : str;
    }

    public static String nullToEmpty(String str) {
        return str == null ? EMPTY : str;
    }

    @Deprecated
    public static boolean isNullOrEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isBlank(CharSequence str) {
        if (str == null) {
            return true;
        }
        int length = str.length();
        if (length == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            boolean charNotBlank;
            char c = str.charAt(i);
            boolean bl = charNotBlank = Character.isWhitespace(c) || Character.isSpaceChar(c) || c == '\ufeff' || c == '\u202a';
            if (charNotBlank) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNotEmpty(CharSequence str) {
        return !StringUtil.isEmpty(str);
    }

    public static boolean isNotBlank(CharSequence str) {
        return !StringUtil.isBlank(str);
    }

    public static boolean isAllNotEmpty(CharSequence ... args) {
        return !StringUtil.hasEmpty(args);
    }

    public static boolean hasEmpty(CharSequence ... strList) {
        if (ArrayUtil.isEmpty(strList)) {
            return true;
        }
        for (CharSequence str : strList) {
            if (!StringUtil.isEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static String toUnderlineCase(CharSequence str) {
        return StringUtil.toSymbolCase(str, '_');
    }

    public static String toSymbolCase(CharSequence str, char symbol) {
        if (str == null) {
            return null;
        }
        int length = str.length();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            Character preChar;
            char c = str.charAt(i);
            Character c2 = preChar = i > 0 ? Character.valueOf(str.charAt(i - 1)) : null;
            if (Character.isUpperCase(c)) {
                Character nextChar;
                Character c3 = nextChar = i < str.length() - 1 ? Character.valueOf(str.charAt(i + 1)) : null;
                if (null != preChar && Character.isUpperCase(preChar.charValue())) {
                    sb.append(c);
                    continue;
                }
                if (null != nextChar && Character.isUpperCase(nextChar.charValue())) {
                    if (null != preChar && symbol != preChar.charValue()) {
                        sb.append(symbol);
                    }
                    sb.append(c);
                    continue;
                }
                if (null != preChar && symbol != preChar.charValue()) {
                    sb.append(symbol);
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            if (sb.length() > 0 && Character.isUpperCase(sb.charAt(sb.length() - 1)) && symbol != c) {
                sb.append(symbol);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toCamelCase(CharSequence str, char symbol) {
        if (null == str || str.length() == 0) {
            return null;
        }
        int length = str.length();
        StringBuilder sb = new StringBuilder(length);
        boolean upperCase = false;
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c == symbol) {
                upperCase = true;
                continue;
            }
            if (upperCase) {
                sb.append(Character.toUpperCase(c));
                upperCase = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String newBuilder(CharSequence ... charSequences) {
        if (charSequences == null || charSequences.length == 0) {
            return EMPTY;
        }
        return StringUtil.createBuilder(charSequences).toString();
    }

    public static StringBuilder createBuilder(CharSequence ... charSequences) {
        StringBuilder builder = new StringBuilder();
        if (charSequences == null || charSequences.length == 0) {
            return builder;
        }
        for (CharSequence sequence : charSequences) {
            builder.append(sequence);
        }
        return builder;
    }

    public static StringBuilder appends(StringBuilder builder, CharSequence ... charSequences) {
        if (builder == null) {
            return StringUtil.createBuilder(charSequences);
        }
        if (charSequences == null || charSequences.length == 0) {
            return builder;
        }
        for (CharSequence sequence : charSequences) {
            builder.append(sequence);
        }
        return builder;
    }

    public static String replace(String str, String searchStr, String replaceStr) {
        return Pattern.compile(searchStr, 16).matcher(str).replaceAll(Matcher.quoteReplacement(replaceStr));
    }

    public static String[] split(String str, String separatorChars) {
        if (str == null) {
            return null;
        }
        if (StringUtil.isBlank(str)) {
            return EMPTY_ARRAY;
        }
        if (StringUtil.isBlank(separatorChars)) {
            return str.split(" ");
        }
        return str.split(separatorChars);
    }

    public static boolean startWith(String str, String prefix) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        return str.startsWith(prefix);
    }

    public static String subBefore(String str, String symbol) {
        if (StringUtil.isEmpty(str) || symbol == null) {
            return str;
        }
        if (symbol.isEmpty()) {
            return EMPTY;
        }
        int pos = str.indexOf(symbol);
        if (-1 == pos) {
            return str;
        }
        if (0 == pos) {
            return EMPTY;
        }
        return str.substring(0, pos);
    }
}

