/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.toolkit.http;

import cn.hippo4j.common.toolkit.IoUtil;
import cn.hippo4j.common.toolkit.http.Header;
import cn.hippo4j.common.toolkit.http.HttpClientResponse;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;

public class JdkHttpClientResponse
implements HttpClientResponse {
    private final HttpURLConnection conn;
    private InputStream responseStream;
    private Header responseHeader;
    private static final String CONTENT_ENCODING = "gzip";

    public JdkHttpClientResponse(HttpURLConnection conn) {
        this.conn = conn;
    }

    @Override
    public Header getHeaders() {
        if (this.responseHeader == null) {
            this.responseHeader = Header.newInstance();
        }
        for (Map.Entry<String, List<String>> entry : this.conn.getHeaderFields().entrySet()) {
            this.responseHeader.addOriginalResponseHeader(entry.getKey(), entry.getValue());
        }
        return this.responseHeader;
    }

    @Override
    public InputStream getBody() {
        Header headers = this.getHeaders();
        InputStream errorStream = this.conn.getErrorStream();
        this.responseStream = errorStream != null ? errorStream : this.conn.getInputStream();
        String contentEncoding = headers.getValue("Content-Encoding");
        if (CONTENT_ENCODING.equals(contentEncoding)) {
            byte[] bytes = IoUtil.tryDecompress(this.responseStream);
            return new ByteArrayInputStream(bytes);
        }
        return this.responseStream;
    }

    @Override
    public int getStatusCode() {
        return this.conn.getResponseCode();
    }

    @Override
    public String getStatusText() {
        return this.conn.getResponseMessage();
    }

    @Override
    public String getBodyString() {
        return IoUtil.toString(this.getBody(), "UTF-8");
    }

    @Override
    public void close() {
        IoUtil.closeQuietly((Closeable)this.responseStream);
    }
}

