/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.common.toolkit.logtracing;

import cn.hippo4j.common.toolkit.StringUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class LogMessage {
    private Map<String, Object> kvs = new ConcurrentHashMap<String, Object>();
    private String msg = "";

    public static LogMessage getInstance() {
        return new LogMessage();
    }

    public LogMessage setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public String msg(String msg, Object ... args) {
        LogMessage l = new LogMessage();
        l.kvs = this.kvs;
        return l.setMsgString(msg, args);
    }

    public LogMessage setMsg(String msg, Object ... args) {
        FormattingTuple ft = MessageFormatter.arrayFormat((String)msg, (Object[])args);
        this.msg = ft.getThrowable() == null ? ft.getMessage() : ft.getMessage() + "||_fmt_throw=" + ft.getThrowable();
        return this;
    }

    public String setMsgString(String msg, Object ... args) {
        FormattingTuple ft = MessageFormatter.arrayFormat((String)msg, (Object[])args);
        this.msg = ft.getThrowable() == null ? ft.getMessage() : ft.getMessage() + "||_fmt_throw=" + ft.getThrowable();
        return this.toString();
    }

    public LogMessage kv(String k, Object v) {
        this.kvs.put(k, v == null ? "" : v);
        return this;
    }

    public String kv2String(String k, Object v) {
        this.kvs.put(k, v == null ? "" : v);
        return this.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (StringUtil.isNotEmpty(this.msg)) {
            sb.append(this.msg);
        }
        int tempCount = 0;
        for (Map.Entry<String, Object> kv : this.kvs.entrySet()) {
            ++tempCount;
            Object value = kv.getValue();
            if (value == null || value instanceof String && StringUtil.isEmpty((String)value)) continue;
            sb.append(kv.getKey() + "=").append(kv.getValue());
            if (tempCount == this.kvs.size()) continue;
            sb.append("||");
        }
        return sb.toString();
    }

    @Generated
    private LogMessage() {
    }
}

