/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.executor;

import cn.hippo4j.core.executor.DynamicThreadPoolExecutor;
import cn.hippo4j.core.provider.CommonDynamicThreadPoolProviderFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import org.springframework.beans.factory.DisposableBean;

public class DynamicThreadPoolWrapper
implements DisposableBean {
    private String tenantId;
    private String itemId;
    private String threadPoolId;
    private boolean subscribeFlag;
    private boolean initFlag;
    private ThreadPoolExecutor executor;

    public DynamicThreadPoolWrapper(String threadPoolId) {
        this(threadPoolId, CommonDynamicThreadPoolProviderFactory.getInstance(threadPoolId));
    }

    public DynamicThreadPoolWrapper(String threadPoolId, ThreadPoolExecutor threadPoolExecutor) {
        this.threadPoolId = threadPoolId;
        this.executor = threadPoolExecutor;
        this.subscribeFlag = true;
    }

    public void execute(Runnable command) {
        this.executor.execute(command);
    }

    public Future<?> submit(Runnable task) {
        return this.executor.submit(task);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.executor.submit(task);
    }

    public void destroy() throws Exception {
        if (this.executor instanceof DynamicThreadPoolExecutor) {
            ((DynamicThreadPoolExecutor)this.executor).destroy();
        }
    }

    @Generated
    public static DynamicThreadPoolWrapperBuilder builder() {
        return new DynamicThreadPoolWrapperBuilder();
    }

    @Generated
    public String getTenantId() {
        return this.tenantId;
    }

    @Generated
    public String getItemId() {
        return this.itemId;
    }

    @Generated
    public String getThreadPoolId() {
        return this.threadPoolId;
    }

    @Generated
    public boolean isSubscribeFlag() {
        return this.subscribeFlag;
    }

    @Generated
    public boolean isInitFlag() {
        return this.initFlag;
    }

    @Generated
    public ThreadPoolExecutor getExecutor() {
        return this.executor;
    }

    @Generated
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Generated
    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    @Generated
    public void setThreadPoolId(String threadPoolId) {
        this.threadPoolId = threadPoolId;
    }

    @Generated
    public void setSubscribeFlag(boolean subscribeFlag) {
        this.subscribeFlag = subscribeFlag;
    }

    @Generated
    public void setInitFlag(boolean initFlag) {
        this.initFlag = initFlag;
    }

    @Generated
    public void setExecutor(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicThreadPoolWrapper)) {
            return false;
        }
        DynamicThreadPoolWrapper other = (DynamicThreadPoolWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$itemId = this.getItemId();
        String other$itemId = other.getItemId();
        if (this$itemId == null ? other$itemId != null : !this$itemId.equals(other$itemId)) {
            return false;
        }
        String this$threadPoolId = this.getThreadPoolId();
        String other$threadPoolId = other.getThreadPoolId();
        if (this$threadPoolId == null ? other$threadPoolId != null : !this$threadPoolId.equals(other$threadPoolId)) {
            return false;
        }
        if (this.isSubscribeFlag() != other.isSubscribeFlag()) {
            return false;
        }
        if (this.isInitFlag() != other.isInitFlag()) {
            return false;
        }
        ThreadPoolExecutor this$executor = this.getExecutor();
        ThreadPoolExecutor other$executor = other.getExecutor();
        return !(this$executor == null ? other$executor != null : !this$executor.equals(other$executor));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DynamicThreadPoolWrapper;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $itemId = this.getItemId();
        result = result * 59 + ($itemId == null ? 43 : $itemId.hashCode());
        String $threadPoolId = this.getThreadPoolId();
        result = result * 59 + ($threadPoolId == null ? 43 : $threadPoolId.hashCode());
        result = result * 59 + (this.isSubscribeFlag() ? 79 : 97);
        result = result * 59 + (this.isInitFlag() ? 79 : 97);
        ThreadPoolExecutor $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DynamicThreadPoolWrapper(tenantId=" + this.getTenantId() + ", itemId=" + this.getItemId() + ", threadPoolId=" + this.getThreadPoolId() + ", subscribeFlag=" + this.isSubscribeFlag() + ", initFlag=" + this.isInitFlag() + ", executor=" + this.getExecutor() + ")";
    }

    @Generated
    public DynamicThreadPoolWrapper() {
    }

    @Generated
    public DynamicThreadPoolWrapper(String tenantId, String itemId, String threadPoolId, boolean subscribeFlag, boolean initFlag, ThreadPoolExecutor executor) {
        this.tenantId = tenantId;
        this.itemId = itemId;
        this.threadPoolId = threadPoolId;
        this.subscribeFlag = subscribeFlag;
        this.initFlag = initFlag;
        this.executor = executor;
    }

    @Generated
    public static class DynamicThreadPoolWrapperBuilder {
        @Generated
        private String tenantId;
        @Generated
        private String itemId;
        @Generated
        private String threadPoolId;
        @Generated
        private boolean subscribeFlag;
        @Generated
        private boolean initFlag;
        @Generated
        private ThreadPoolExecutor executor;

        @Generated
        DynamicThreadPoolWrapperBuilder() {
        }

        @Generated
        public DynamicThreadPoolWrapperBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Generated
        public DynamicThreadPoolWrapperBuilder itemId(String itemId) {
            this.itemId = itemId;
            return this;
        }

        @Generated
        public DynamicThreadPoolWrapperBuilder threadPoolId(String threadPoolId) {
            this.threadPoolId = threadPoolId;
            return this;
        }

        @Generated
        public DynamicThreadPoolWrapperBuilder subscribeFlag(boolean subscribeFlag) {
            this.subscribeFlag = subscribeFlag;
            return this;
        }

        @Generated
        public DynamicThreadPoolWrapperBuilder initFlag(boolean initFlag) {
            this.initFlag = initFlag;
            return this;
        }

        @Generated
        public DynamicThreadPoolWrapperBuilder executor(ThreadPoolExecutor executor) {
            this.executor = executor;
            return this;
        }

        @Generated
        public DynamicThreadPoolWrapper build() {
            return new DynamicThreadPoolWrapper(this.tenantId, this.itemId, this.threadPoolId, this.subscribeFlag, this.initFlag, this.executor);
        }

        @Generated
        public String toString() {
            return "DynamicThreadPoolWrapper.DynamicThreadPoolWrapperBuilder(tenantId=" + this.tenantId + ", itemId=" + this.itemId + ", threadPoolId=" + this.threadPoolId + ", subscribeFlag=" + this.subscribeFlag + ", initFlag=" + this.initFlag + ", executor=" + this.executor + ")";
        }
    }
}

