/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.executor.state;

import cn.hippo4j.common.model.ManyThreadPoolRunStateInfo;
import cn.hippo4j.common.model.ThreadPoolRunStateInfo;
import cn.hippo4j.common.toolkit.BeanUtil;
import cn.hippo4j.common.toolkit.ByteConvertUtil;
import cn.hippo4j.common.toolkit.MemoryUtil;
import cn.hippo4j.common.toolkit.StringUtil;
import cn.hippo4j.core.executor.DynamicThreadPoolWrapper;
import cn.hippo4j.core.executor.manage.GlobalThreadPoolManage;
import cn.hippo4j.core.executor.state.AbstractThreadPoolRuntime;
import cn.hippo4j.core.executor.state.ThreadPoolStatusHandler;
import cn.hippo4j.core.toolkit.IdentifyUtil;
import cn.hippo4j.core.toolkit.inet.InetUtils;
import java.util.concurrent.ThreadPoolExecutor;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;

public class ThreadPoolRunStateHandler
extends AbstractThreadPoolRuntime {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolRunStateHandler.class);
    private final InetUtils hippo4JInetUtils;
    private final ConfigurableEnvironment environment;

    @Override
    public ThreadPoolRunStateInfo supplement(ThreadPoolRunStateInfo poolRunStateInfo) {
        long used = MemoryUtil.heapMemoryUsed();
        long max = MemoryUtil.heapMemoryMax();
        String memoryProportion = StringUtil.newBuilder((CharSequence[])new CharSequence[]{"Allocation: ", ByteConvertUtil.getPrintSize((long)used), " / Maximum available: ", ByteConvertUtil.getPrintSize((long)max)});
        poolRunStateInfo.setCurrentLoad(poolRunStateInfo.getCurrentLoad() + "%");
        poolRunStateInfo.setPeakLoad(poolRunStateInfo.getPeakLoad() + "%");
        String ipAddress = this.hippo4JInetUtils.findFirstNonLoopBackHostInfo().getIpAddress();
        poolRunStateInfo.setHost(ipAddress);
        poolRunStateInfo.setMemoryProportion(memoryProportion);
        poolRunStateInfo.setFreeMemory(ByteConvertUtil.getPrintSize((long)Math.subtractExact(max, used)));
        String threadPoolId = poolRunStateInfo.getTpId();
        DynamicThreadPoolWrapper executorService = GlobalThreadPoolManage.getExecutorService(threadPoolId);
        ThreadPoolExecutor pool = executorService.getExecutor();
        String rejectedName = pool.getRejectedExecutionHandler().getClass().getSimpleName();
        poolRunStateInfo.setRejectedName(rejectedName);
        ManyThreadPoolRunStateInfo manyThreadPoolRunStateInfo = (ManyThreadPoolRunStateInfo)BeanUtil.convert((Object)poolRunStateInfo, ManyThreadPoolRunStateInfo.class);
        manyThreadPoolRunStateInfo.setIdentify(IdentifyUtil.CLIENT_IDENTIFICATION_VALUE);
        String active = this.environment.getProperty("spring.profiles.active", "UNKNOWN");
        manyThreadPoolRunStateInfo.setActive(active.toUpperCase());
        String threadPoolState = ThreadPoolStatusHandler.getThreadPoolState(pool);
        manyThreadPoolRunStateInfo.setState(threadPoolState);
        return manyThreadPoolRunStateInfo;
    }

    @Generated
    public ThreadPoolRunStateHandler(InetUtils hippo4JInetUtils, ConfigurableEnvironment environment) {
        this.hippo4JInetUtils = hippo4JInetUtils;
        this.environment = environment;
    }
}

