/*
 * Decompiled with CFR 0.152.
 */
package cn.hippo4j.core.plugin.manager;

import cn.hippo4j.core.plugin.ThreadPoolPlugin;
import cn.hippo4j.core.plugin.manager.GlobalThreadPoolPluginManager;
import cn.hippo4j.core.plugin.manager.ThreadPoolPluginRegistrar;
import cn.hippo4j.core.plugin.manager.ThreadPoolPluginSupport;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DefaultGlobalThreadPoolPluginManager
implements GlobalThreadPoolPluginManager {
    private final Map<String, ThreadPoolPlugin> enableThreadPoolPlugins = new ConcurrentHashMap<String, ThreadPoolPlugin>(8);
    private final Map<String, ThreadPoolPluginRegistrar> enableThreadPoolPluginRegistrars = new ConcurrentHashMap<String, ThreadPoolPluginRegistrar>(8);
    private final Map<String, ThreadPoolPluginSupport> managedThreadPoolPluginSupports = new ConcurrentHashMap<String, ThreadPoolPluginSupport>(32);

    @Override
    public void doRegister(@NonNull ThreadPoolPluginSupport support) {
        if (support == null) {
            throw new NullPointerException("support is marked non-null but is null");
        }
        this.enableThreadPoolPluginRegistrars.values().forEach(registrar -> registrar.doRegister(support));
        this.enableThreadPoolPlugins.values().forEach(support::tryRegister);
    }

    @Override
    public boolean registerThreadPoolPluginSupport(@NonNull ThreadPoolPluginSupport support) {
        if (support == null) {
            throw new NullPointerException("support is marked non-null but is null");
        }
        if (!this.managedThreadPoolPluginSupports.containsKey(support.getThreadPoolId())) {
            this.enableThreadPoolPluginRegistrars.values().forEach(registrar -> registrar.doRegister(support));
            this.enableThreadPoolPlugins.values().forEach(support::tryRegister);
            this.managedThreadPoolPluginSupports.put(support.getThreadPoolId(), support);
            return true;
        }
        return false;
    }

    @Override
    public ThreadPoolPluginSupport cancelManagement(String threadPoolId) {
        return this.managedThreadPoolPluginSupports.remove(threadPoolId);
    }

    @Override
    public @Nullable ThreadPoolPluginSupport getManagedThreadPoolPluginSupport(String threadPoolId) {
        return this.managedThreadPoolPluginSupports.get(threadPoolId);
    }

    @Override
    public Collection<ThreadPoolPluginSupport> getAllManagedThreadPoolPluginSupports() {
        return this.managedThreadPoolPluginSupports.values();
    }

    @Override
    public boolean enableThreadPoolPlugin(@NonNull ThreadPoolPlugin plugin) {
        if (plugin == null) {
            throw new NullPointerException("plugin is marked non-null but is null");
        }
        if (Objects.isNull(this.enableThreadPoolPlugins.put(plugin.getId(), plugin))) {
            this.managedThreadPoolPluginSupports.values().forEach(support -> support.register(plugin));
            return true;
        }
        return false;
    }

    @Override
    public Collection<ThreadPoolPlugin> getAllEnableThreadPoolPlugins() {
        return this.enableThreadPoolPlugins.values();
    }

    @Override
    public ThreadPoolPlugin disableThreadPoolPlugin(String pluginId) {
        ThreadPoolPlugin removed = this.enableThreadPoolPlugins.remove(pluginId);
        if (Objects.nonNull(removed)) {
            this.managedThreadPoolPluginSupports.values().forEach(support -> support.unregister(pluginId));
        }
        return removed;
    }

    @Override
    public boolean enableThreadPoolPluginRegistrar(@NonNull ThreadPoolPluginRegistrar registrar) {
        if (registrar == null) {
            throw new NullPointerException("registrar is marked non-null but is null");
        }
        if (Objects.isNull(this.enableThreadPoolPluginRegistrars.put(registrar.getId(), registrar))) {
            this.managedThreadPoolPluginSupports.values().forEach(registrar::doRegister);
            return true;
        }
        return false;
    }

    @Override
    public Collection<ThreadPoolPluginRegistrar> getAllEnableThreadPoolPluginRegistrar() {
        return this.enableThreadPoolPluginRegistrars.values();
    }

    @Override
    public ThreadPoolPluginRegistrar disableThreadPoolPluginRegistrar(String registrarId) {
        return this.enableThreadPoolPluginRegistrars.remove(registrarId);
    }
}

