/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.bloomfilter;

import cn.hutool.bloomfilter.BloomFilter;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.HashUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.BitSet;

public class BitSetBloomFilter
implements BloomFilter {
    private static final long serialVersionUID = 1L;
    private BitSet bitSet;
    private int bitSetSize;
    private int addedElements;
    private int hashFunctionNumber;

    public BitSetBloomFilter(int c, int n, int k) {
        this.hashFunctionNumber = k;
        this.bitSetSize = (int)Math.ceil(c * k);
        this.addedElements = n;
        this.bitSet = new BitSet(this.bitSetSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String path, String charset) throws IOException {
        BufferedReader reader = FileUtil.getReader(path, charset);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                this.add(line);
            }
        }
        finally {
            IoUtil.close(reader);
        }
    }

    @Override
    public boolean add(String str) {
        if (this.contains(str)) {
            return false;
        }
        int[] positions = BitSetBloomFilter.createHashes(str, this.hashFunctionNumber);
        for (int i = 0; i < positions.length; ++i) {
            int position = Math.abs(positions[i] % this.bitSetSize);
            this.bitSet.set(position, true);
        }
        return true;
    }

    @Override
    public boolean contains(String str) {
        int[] positions;
        for (int i : positions = BitSetBloomFilter.createHashes(str, this.hashFunctionNumber)) {
            int position = Math.abs(i % this.bitSetSize);
            if (this.bitSet.get(position)) continue;
            return false;
        }
        return true;
    }

    public double getFalsePositiveProbability() {
        return Math.pow(1.0 - Math.exp((double)(-this.hashFunctionNumber) * (double)this.addedElements / (double)this.bitSetSize), this.hashFunctionNumber);
    }

    public static int[] createHashes(String str, int hashNumber) {
        int[] result = new int[hashNumber];
        for (int i = 0; i < hashNumber; ++i) {
            result[i] = BitSetBloomFilter.hash(str, i);
        }
        return result;
    }

    public static int hash(String str, int k) {
        switch (k) {
            case 0: {
                return HashUtil.rsHash(str);
            }
            case 1: {
                return HashUtil.jsHash(str);
            }
            case 2: {
                return HashUtil.elfHash(str);
            }
            case 3: {
                return HashUtil.bkdrHash(str);
            }
            case 4: {
                return HashUtil.apHash(str);
            }
            case 5: {
                return HashUtil.djbHash(str);
            }
            case 6: {
                return HashUtil.sdbmHash(str);
            }
            case 7: {
                return HashUtil.pjwHash(str);
            }
        }
        return 0;
    }
}

