/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.util;

import cn.hutool.core.lang.ParameterizedTypeImpl;
import cn.hutool.core.lang.reflect.ActualTypeMapperPool;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Map;

public class TypeUtil {
    public static Class<?> getClass(Type type) {
        if (null != type) {
            Type[] upperBounds;
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                return (Class)((ParameterizedType)type).getRawType();
            }
            if (type instanceof TypeVariable) {
                Type[] bounds = ((TypeVariable)type).getBounds();
                if (bounds.length == 1) {
                    return TypeUtil.getClass(bounds[0]);
                }
            } else if (type instanceof WildcardType && (upperBounds = ((WildcardType)type).getUpperBounds()).length == 1) {
                return TypeUtil.getClass(upperBounds[0]);
            }
        }
        return null;
    }

    public static Type getType(Field field) {
        if (null == field) {
            return null;
        }
        return field.getGenericType();
    }

    public static Type getFieldType(Class<?> clazz, String fieldName) {
        return TypeUtil.getType(ReflectUtil.getField(clazz, fieldName));
    }

    public static Class<?> getClass(Field field) {
        return null == field ? null : field.getType();
    }

    public static Type getFirstParamType(Method method) {
        return TypeUtil.getParamType(method, 0);
    }

    public static Class<?> getFirstParamClass(Method method) {
        return TypeUtil.getParamClass(method, 0);
    }

    public static Type getParamType(Method method, int index) {
        Type[] types = TypeUtil.getParamTypes(method);
        if (null != types && types.length > index) {
            return types[index];
        }
        return null;
    }

    public static Class<?> getParamClass(Method method, int index) {
        Class<?>[] classes = TypeUtil.getParamClasses(method);
        if (null != classes && classes.length > index) {
            return classes[index];
        }
        return null;
    }

    public static Type[] getParamTypes(Method method) {
        return null == method ? null : method.getGenericParameterTypes();
    }

    public static Class<?>[] getParamClasses(Method method) {
        return null == method ? null : method.getParameterTypes();
    }

    public static Type getReturnType(Method method) {
        return null == method ? null : method.getGenericReturnType();
    }

    public static Class<?> getReturnClass(Method method) {
        return null == method ? null : method.getReturnType();
    }

    public static Type getTypeArgument(Type type) {
        return TypeUtil.getTypeArgument(type, 0);
    }

    public static Type getTypeArgument(Type type, int index) {
        Type[] typeArguments = TypeUtil.getTypeArguments(type);
        if (null != typeArguments && typeArguments.length > index) {
            return typeArguments[index];
        }
        return null;
    }

    public static Type[] getTypeArguments(Type type) {
        if (null == type) {
            return null;
        }
        ParameterizedType parameterizedType = TypeUtil.toParameterizedType(type);
        return null == parameterizedType ? null : parameterizedType.getActualTypeArguments();
    }

    public static ParameterizedType toParameterizedType(Type type) {
        return TypeUtil.toParameterizedType(type, 0);
    }

    public static ParameterizedType toParameterizedType(Type type, int interfaceIndex) {
        ParameterizedType[] generics;
        if (type instanceof ParameterizedType) {
            return (ParameterizedType)type;
        }
        if (type instanceof Class && (generics = TypeUtil.getGenerics((Class)type)).length > interfaceIndex) {
            return generics[interfaceIndex];
        }
        return null;
    }

    public static ParameterizedType[] getGenerics(Class<?> clazz) {
        Type[] genericInterfaces;
        ParameterizedType parameterizedType;
        ArrayList<ParameterizedType> result = new ArrayList<ParameterizedType>();
        Type genericSuper = clazz.getGenericSuperclass();
        if (null != genericSuper && !Object.class.equals((Object)genericSuper) && null != (parameterizedType = TypeUtil.toParameterizedType(genericSuper))) {
            result.add(parameterizedType);
        }
        if (ArrayUtil.isNotEmpty(genericInterfaces = clazz.getGenericInterfaces())) {
            for (Type genericInterface : genericInterfaces) {
                ParameterizedType parameterizedType2 = TypeUtil.toParameterizedType(genericInterface);
                if (null == parameterizedType2) continue;
                result.add(parameterizedType2);
            }
        }
        return result.toArray(new ParameterizedType[0]);
    }

    public static boolean isUnknown(Type type) {
        return null == type || type instanceof TypeVariable;
    }

    public static boolean hasTypeVariable(Type ... types) {
        for (Type type : types) {
            if (!(type instanceof TypeVariable)) continue;
            return true;
        }
        return false;
    }

    public static Map<Type, Type> getTypeMap(Class<?> clazz) {
        return ActualTypeMapperPool.get(clazz);
    }

    public static Type getActualType(Type type, Field field) {
        if (null == field) {
            return null;
        }
        return TypeUtil.getActualType(ObjectUtil.defaultIfNull(type, field::getDeclaringClass), field.getGenericType());
    }

    public static Type getActualType(Type type, Type typeVariable) {
        Type actualType;
        if (typeVariable instanceof ParameterizedType) {
            return TypeUtil.getActualType(type, (ParameterizedType)typeVariable);
        }
        if (typeVariable instanceof TypeVariable) {
            return ActualTypeMapperPool.getActualType(type, (TypeVariable)typeVariable);
        }
        if (typeVariable instanceof GenericArrayType && null != (actualType = ActualTypeMapperPool.getActualType(type, (GenericArrayType)typeVariable))) {
            return actualType;
        }
        return typeVariable;
    }

    public static Type getActualType(Type type, ParameterizedType parameterizedType) {
        Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
        if (TypeUtil.hasTypeVariable(actualTypeArguments) && ArrayUtil.isNotEmpty(actualTypeArguments = TypeUtil.getActualTypes(type, parameterizedType.getActualTypeArguments()))) {
            parameterizedType = new ParameterizedTypeImpl(actualTypeArguments, parameterizedType.getOwnerType(), parameterizedType.getRawType());
        }
        return parameterizedType;
    }

    public static Type[] getActualTypes(Type type, Type ... typeVariables) {
        return ActualTypeMapperPool.getActualTypes(type, typeVariables);
    }
}

