/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.ai.model.ollama;

import cn.hutool.ai.AIException;
import cn.hutool.ai.core.AIConfig;
import cn.hutool.ai.core.BaseAIService;
import cn.hutool.ai.core.Message;
import cn.hutool.ai.model.ollama.OllamaService;
import cn.hutool.core.bean.BeanPath;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.Header;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class OllamaServiceImpl
extends BaseAIService
implements OllamaService {
    private static final String CHAT_ENDPOINT = "/api/chat";
    private static final String GENERATE_ENDPOINT = "/api/generate";
    private static final String EMBEDDINGS_ENDPOINT = "/api/embeddings";
    private static final String LIST_MODELS_ENDPOINT = "/api/tags";
    private static final String SHOW_MODEL_ENDPOINT = "/api/show";
    private static final String PULL_MODEL_ENDPOINT = "/api/pull";
    private static final String DELETE_MODEL_ENDPOINT = "/api/delete";
    private static final String COPY_MODEL_ENDPOINT = "/api/copy";

    public OllamaServiceImpl(AIConfig config) {
        super(config);
    }

    @Override
    public String chat(List<Message> messages) {
        String paramJson = this.buildChatRequestBody(messages);
        HttpResponse response = this.sendPost(CHAT_ENDPOINT, paramJson);
        JSONObject responseJson = JSONUtil.parseObj(response.body());
        Object errorMessage = BeanPath.create("error").get(responseJson);
        if (errorMessage != null) {
            throw new RuntimeException(errorMessage.toString());
        }
        return BeanPath.create("message.content").get(responseJson).toString();
    }

    @Override
    public void chat(List<Message> messages, Consumer<String> callback) {
        Map<String, Object> paramMap = this.buildChatStreamRequestBody(messages);
        ThreadUtil.newThread(() -> this.sendPostStream(CHAT_ENDPOINT, paramMap, callback::accept), "ollama-chat-sse").start();
    }

    @Override
    public String generate(String prompt) {
        String paramJson = this.buildGenerateRequestBody(prompt, null);
        HttpResponse response = this.sendPost(GENERATE_ENDPOINT, paramJson);
        return response.body();
    }

    @Override
    public void generate(String prompt, Consumer<String> callback) {
        Map<String, Object> paramMap = this.buildGenerateStreamRequestBody(prompt, null);
        ThreadUtil.newThread(() -> this.sendPostStream(GENERATE_ENDPOINT, paramMap, callback::accept), "ollama-generate-sse").start();
    }

    @Override
    public String generate(String prompt, String format) {
        String paramJson = this.buildGenerateRequestBody(prompt, format);
        HttpResponse response = this.sendPost(GENERATE_ENDPOINT, paramJson);
        return response.body();
    }

    @Override
    public void generate(String prompt, String format, Consumer<String> callback) {
        Map<String, Object> paramMap = this.buildGenerateStreamRequestBody(prompt, format);
        ThreadUtil.newThread(() -> this.sendPostStream(GENERATE_ENDPOINT, paramMap, callback::accept), "ollama-generate-sse").start();
    }

    @Override
    public String embeddings(String prompt) {
        String paramJson = this.buildEmbeddingsRequestBody(prompt);
        HttpResponse response = this.sendPost(EMBEDDINGS_ENDPOINT, paramJson);
        return response.body();
    }

    @Override
    public String listModels() {
        HttpResponse response = this.sendGet(LIST_MODELS_ENDPOINT);
        return response.body();
    }

    @Override
    public String showModel(String modelName) {
        String paramJson = this.buildShowModelRequestBody(modelName);
        HttpResponse response = this.sendPost(SHOW_MODEL_ENDPOINT, paramJson);
        return response.body();
    }

    @Override
    public String pullModel(String modelName) {
        String paramJson = this.buildPullModelRequestBody(modelName);
        HttpResponse response = this.sendPost(PULL_MODEL_ENDPOINT, paramJson);
        return response.body();
    }

    @Override
    public String deleteModel(String modelName) {
        String paramJson = this.buildDeleteModelRequestBody(modelName);
        HttpResponse response = this.sendDeleteRequest(DELETE_MODEL_ENDPOINT, paramJson);
        return response.body();
    }

    @Override
    public String copyModel(String source, String destination) {
        String paramJson = this.buildCopyModelRequestBody(source, destination);
        HttpResponse response = this.sendPost(COPY_MODEL_ENDPOINT, paramJson);
        return response.body();
    }

    private String buildChatRequestBody(List<Message> messages) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("stream", false);
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private Map<String, Object> buildChatStreamRequestBody(List<Message> messages) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("stream", true);
        paramMap.put("model", this.config.getModel());
        paramMap.put("messages", messages);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return paramMap;
    }

    private String buildGenerateRequestBody(String prompt, String format) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("prompt", prompt);
        if (StrUtil.isNotBlank(format)) {
            paramMap.put("format", format);
        }
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private Map<String, Object> buildGenerateStreamRequestBody(String prompt, String format) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("stream", true);
        paramMap.put("model", this.config.getModel());
        paramMap.put("prompt", prompt);
        if (StrUtil.isNotBlank(format)) {
            paramMap.put("format", format);
        }
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return paramMap;
    }

    private String buildEmbeddingsRequestBody(String prompt) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("model", this.config.getModel());
        paramMap.put("prompt", prompt);
        paramMap.putAll(this.config.getAdditionalConfigMap());
        return JSONUtil.toJsonStr(paramMap);
    }

    private String buildShowModelRequestBody(String modelName) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("name", modelName);
        return JSONUtil.toJsonStr(paramMap);
    }

    private String buildPullModelRequestBody(String modelName) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("name", modelName);
        return JSONUtil.toJsonStr(paramMap);
    }

    private String buildDeleteModelRequestBody(String modelName) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("name", modelName);
        return JSONUtil.toJsonStr(paramMap);
    }

    private HttpResponse sendDeleteRequest(String endpoint, String paramJson) {
        try {
            return ((HttpRequest)((HttpRequest)HttpRequest.delete(this.config.getApiUrl() + endpoint).header(Header.CONTENT_TYPE, "application/json")).header(Header.ACCEPT, "application/json")).body(paramJson).timeout(this.config.getTimeout()).execute();
        }
        catch (Exception e) {
            throw new AIException("Failed to send DELETE request: " + e.getMessage(), e);
        }
    }

    private String buildCopyModelRequestBody(String source, String destination) {
        HashMap<String, String> requestBody = new HashMap<String, String>();
        requestBody.put("source", source);
        requestBody.put("destination", destination);
        return JSONUtil.toJsonStr(requestBody);
    }
}

