/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.ai.model.openai;

import cn.hutool.ai.core.AIService;
import cn.hutool.ai.core.Message;
import cn.hutool.ai.model.openai.OpenaiCommon;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public interface OpenaiService
extends AIService {
    public String chatVision(String var1, List<String> var2, String var3);

    public void chatVision(String var1, List<String> var2, String var3, Consumer<String> var4);

    default public String chatVision(String prompt, List<String> images) {
        return this.chatVision(prompt, images, OpenaiCommon.OpenaiVision.AUTO.getDetail());
    }

    default public void chatVision(String prompt, List<String> images, Consumer<String> callback) {
        this.chatVision(prompt, images, OpenaiCommon.OpenaiVision.AUTO.getDetail(), callback);
    }

    public String imagesGenerations(String var1);

    public String imagesEdits(String var1, File var2, File var3);

    default public String imagesEdits(String prompt, File image) {
        return this.imagesEdits(prompt, image, null);
    }

    public String imagesVariations(File var1);

    public InputStream textToSpeech(String var1, OpenaiCommon.OpenaiSpeech var2);

    default public InputStream textToSpeech(String input) {
        return this.textToSpeech(input, OpenaiCommon.OpenaiSpeech.ALLOY);
    }

    public String speechToText(File var1);

    public String embeddingText(String var1);

    public String moderations(String var1, String var2);

    default public String moderations(String text) {
        return this.moderations(text, null);
    }

    default public String chatReasoning(String prompt, String reasoningEffort) {
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.add(new Message("system", "You are a helpful assistant"));
        messages.add(new Message("user", prompt));
        return this.chatReasoning(messages, reasoningEffort);
    }

    default public void chatReasoning(String prompt, String reasoningEffort, Consumer<String> callback) {
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.add(new Message("system", "You are a helpful assistant"));
        messages.add(new Message("user", prompt));
        this.chatReasoning(messages, reasoningEffort, callback);
    }

    default public String chatReasoning(String prompt) {
        return this.chatReasoning(prompt, OpenaiCommon.OpenaiReasoning.MEDIUM.getEffort());
    }

    default public void chatReasoning(String prompt, Consumer<String> callback) {
        this.chatReasoning(prompt, OpenaiCommon.OpenaiReasoning.MEDIUM.getEffort(), callback);
    }

    public String chatReasoning(List<Message> var1, String var2);

    public void chatReasoning(List<Message> var1, String var2, Consumer<String> var3);

    default public String chatReasoning(List<Message> messages) {
        return this.chatReasoning(messages, OpenaiCommon.OpenaiReasoning.MEDIUM.getEffort());
    }

    default public void chatReasoning(List<Message> messages, Consumer<String> callback) {
        this.chatReasoning(messages, OpenaiCommon.OpenaiReasoning.MEDIUM.getEffort(), callback);
    }
}

