/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.setting;

import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.io.resource.NoResourceException;
import cn.hutool.core.util.StrUtil;
import cn.hutool.setting.Setting;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SettingUtil {
    private static final Map<String, Setting> SETTING_MAP = new ConcurrentHashMap<String, Setting>();

    public static Setting get(String name) {
        return SETTING_MAP.computeIfAbsent(name, filePath -> {
            String extName = FileNameUtil.extName((String)filePath);
            if (StrUtil.isEmpty((CharSequence)extName)) {
                filePath = filePath + "." + "setting";
            }
            return new Setting((String)filePath, true);
        });
    }

    public static Setting getFirstFound(String ... names) {
        for (String name : names) {
            try {
                return SettingUtil.get(name);
            }
            catch (NoResourceException noResourceException) {
            }
        }
        return null;
    }
}

